/* 
 * EventMappingResult.java        0.1.4 12/02/16
 * 
 * DEVELOPED BY DECOIT GMBH WITHIN THE ESUKOM-PROJECT:
 * http://www.decoit.de/
 * http://www.esukom.de/cms/front_content.php?idcat=10&lang=1
 * 
 * DERIVED FROM  THE DHCP-IFMAP-CLIENT-IMPLEMENTATION DEVELOPED BY 
 * FHH/TRUST WITHIN THE IRON-PROJECT:
 * http://trust.inform.fh-hannover.de/joomla/
 * 
 * Licensed to the Apache Software Foundation (ASF) under one 
 * or more contributor license agreements.  See the NOTICE file 
 * distributed with this work for additional information 
 * regarding copyright ownership.  The ASF licenses this file 
 * to you under the Apache License, Version 2.0 (the 
 * "License"); you may not use this file except in compliance 
 * with the License.  You may obtain a copy of the License at 
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, 
 * software distributed under the License is distributed on an 
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY 
 * KIND, either express or implied.  See the License for the 
 * specific language governing permissions and limitations 
 * under the License. 
 */

package de.esukom.decoit.ifmapclient.mappingfactory;

import de.fhhannover.inform.trust.ifmapj.metadata.EventType;
import de.fhhannover.inform.trust.ifmapj.metadata.Significance;

/**
 * concrete implementation of mapping-result. represents an IFMAP-Event
 * 
 * @version 0.1.4
 * @author Dennis Dunekacke, Decoit GmbH
 */
public class EventMappingResult extends MappingResult implements Cloneable {

    private String mIp;
    private String mDiscoveredTime;
    private String mDiscovererId;
    private String mMagnitude;
    private String mConfidence;
    private Significance mSignificance;
    private EventType mEventMessageType;
    private String mName;
    private String mIpType;
    private String mVulnerabilityUri;
    private String mIdentity;

    /**
     * (empty) constructor
     */
    public EventMappingResult() {
        // move along, nothing to see here...
    }

    public Object clone() {
        try {
            return super.clone();
        } catch (CloneNotSupportedException e) {
            return null;
        }
    }

    /**
     * @return the ip
     */
    public String getIp() {
        return mIp;
    }

    /**
     * @param ip
     *            the ip to set
     */
    public void setIp(String ip) {
        this.mIp = ip;
    }

    /**
     * @return the discoveredTime
     */
    public String getDiscoveredTime() {
        return mDiscoveredTime;
    }

    /**
     * @param discoveredTime
     *            the discoveredTime to set
     */
    public void setDiscoveredTime(String discoveredTime) {
        this.mDiscoveredTime = discoveredTime;
    }

    /**
     * @return the discovererId
     */
    public String getDiscovererId() {
        return mDiscovererId;
    }

    /**
     * @param discovererId
     *            the discovererId to set
     */
    public void setDiscovererId(String discovererId) {
        this.mDiscovererId = discovererId;
    }

    /**
     * @return the magnitude
     */
    public String getMagnitude() {
        return mMagnitude;
    }

    /**
     * @param magnitude
     *            the magnitude to set
     */
    public void setMagnitude(String magnitude) {
        this.mMagnitude = magnitude;
    }

    /**
     * @return the confidence
     */
    public String getConfidence() {
        return mConfidence;
    }

    /**
     * @param confidence
     *            the confidence to set
     */
    public void setConfidence(String confidence) {
        this.mConfidence = confidence;
    }

    /**
     * @return the significance
     */
    public Significance getSignificance() {
        return mSignificance;
    }

    /**
     * @param significance
     *            the significance to set
     */
    public void setSignificance(Significance significance) {
        this.mSignificance = significance;
    }

    /**
     * @return the eventMessageType
     */
    public EventType getEventMessageType() {
        return mEventMessageType;
    }

    /**
     * @param eventMessageType
     *            the eventMessageType to set
     */
    public void setEventMessageType(EventType eventMessageType) {
        this.mEventMessageType = eventMessageType;
    }

    /**
     * @return the name
     */
    public String getName() {
        return mName;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(String name) {
        this.mName = name;
    }

    /**
     * @return the ipType
     */
    public String getIpType() {
        return mIpType;
    }

    /**
     * @param ipType
     *            the ipType to set
     */
    public void setIpType(String ipType) {
        this.mIpType = ipType;
    }

    /**
     * @return the vulnerabilityUri
     */
    public String getVulnerabilityUri() {
        return mVulnerabilityUri;
    }

    /**
     * @param vulnerabilityUri
     *            the vulnerabilityUri to set
     */
    public void setVulnerabilityUri(String vulnerabilityUri) {
        this.mVulnerabilityUri = vulnerabilityUri;
    }

    @Override
    public String showOnConsole() {
        String returnStr = null;
        returnStr = "--> EventMappingResult \n";
        returnStr += "    identity          : " + getIdentity() + "\n";
        returnStr += "    ip-address        : " + getIp() + "\n";
        returnStr += "    discovered-time   : " + getDiscoveredTime() + "\n";
        returnStr += "    discoverer-id     : " + getDiscovererId() + "\n";
        returnStr += "    magnitude         : " + getMagnitude() + "\n";
        returnStr += "    confidence        : " + getConfidence() + "\n";
        returnStr += "    significance      : " + getSignificance().toString() + "\n";
        returnStr += "    event-msg-type    : " + getEventMessageType().toString() + "\n";
        returnStr += "    name              : " + getName() + "\n";
        returnStr += "    ip-type           : " + getIpType() + "\n";
        returnStr += "    vulnerabilitiy-uri: " + getVulnerabilityUri() + "\n";
        returnStr += "    identity			: " + getIdentity() + "\n";
        returnStr += "\n";
        return returnStr;
    }

    public String getIdentity() {
        return mIdentity;
    }

    public void setIdentity(String identity) {
        this.mIdentity = identity;
    }
}
