/*
 * Decompiled with CFR 0.152.
 */
package de.fhhannover.inform.trust.ifmapj.messages;

import de.fhhannover.inform.trust.ifmapj.exception.IfmapErrorResult;
import de.fhhannover.inform.trust.ifmapj.exception.MarshalException;
import de.fhhannover.inform.trust.ifmapj.exception.UnmarshalException;
import de.fhhannover.inform.trust.ifmapj.messages.NewSessionRequest;
import de.fhhannover.inform.trust.ifmapj.messages.NewSessionResultImpl;
import de.fhhannover.inform.trust.ifmapj.messages.Request;
import de.fhhannover.inform.trust.ifmapj.messages.RequestHandler;
import de.fhhannover.inform.trust.ifmapj.messages.Requests;
import de.fhhannover.inform.trust.ifmapj.messages.Result;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DomHelpers;

class NewSessionRequestHandler
implements RequestHandler<NewSessionRequest> {
    NewSessionRequestHandler() {
    }

    @Override
    public Element toElement(Request req, Document doc) throws MarshalException {
        Requests.Helpers.checkRequestType(req, this);
        NewSessionRequest nsr = (NewSessionRequest)req;
        Element ret = doc.createElementNS(Requests.Helpers.baseNsUri(), DomHelpers.makeRequestFQName("newSession"));
        if (nsr.getMaxPollResultSize() != null) {
            DomHelpers.addAttribute(ret, "max-poll-result-size", nsr.getMaxPollResultSize().toString());
        }
        return ret;
    }

    @Override
    public Result fromElement(Element res) throws UnmarshalException, IfmapErrorResult {
        Element content = Requests.Helpers.getResponseContentErrorCheck(res);
        Integer mprs = null;
        if (!DomHelpers.elementMatches(content, "newSessionResult")) {
            throw new UnmarshalException("No newSession element found");
        }
        String sId = content.getAttribute("session-id");
        String pId = content.getAttribute("ifmap-publisher-id");
        String mprsStr = content.getAttribute("max-poll-result-size");
        if (sId == null || sId.length() == 0) {
            throw new UnmarshalException("No session-id found");
        }
        if (pId == null || pId.length() == 0) {
            throw new UnmarshalException("No ifmap-publisher-id found");
        }
        if (mprsStr != null && mprsStr.length() > 0) {
            try {
                mprs = Integer.parseInt(mprsStr);
            }
            catch (NumberFormatException e) {
                throw new UnmarshalException("Failed to parse max-poll-result-size. Was: " + mprsStr);
            }
        }
        return new NewSessionResultImpl(sId, pId, mprs);
    }

    @Override
    public Class<NewSessionRequest> handles() {
        return NewSessionRequest.class;
    }
}

