/*
 * Decompiled with CFR 0.152.
 */
package de.fhhannover.inform.trust.ifmapj.channel;

import de.fhhannover.inform.trust.ifmapj.channel.ApacheCoreCommunicationHandler;
import de.fhhannover.inform.trust.ifmapj.channel.CommunicationHandler;
import de.fhhannover.inform.trust.ifmapj.channel.JavaCommunicationHandler;
import de.fhhannover.inform.trust.ifmapj.exception.InitializationException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public abstract class CommunicationHandlerFactory {
    public static final String HANDLER_PROPERTY = "ifmapj.communication.handler";

    public static CommunicationHandler newHandler(String url, String user, String pass, SSLSocketFactory sslSocketFactory, HostnameVerifier verifier) throws InitializationException {
        String handler = System.getProperty(HANDLER_PROPERTY);
        if (handler != null) {
            return CommunicationHandlerFactory.newHandlerPreference(handler, url, user, pass, sslSocketFactory, verifier);
        }
        return CommunicationHandlerFactory.newHandlerAuto(url, user, pass, sslSocketFactory, verifier);
    }

    private static CommunicationHandler newHandlerAuto(String url, String user, String pass, SSLSocketFactory sslSocketFactory, HostnameVerifier verifier) throws InitializationException {
        try {
            return new ApacheCoreCommunicationHandler(url, user, pass, sslSocketFactory, verifier);
        }
        catch (NoClassDefFoundError e) {
            return new JavaCommunicationHandler(url, user, pass, sslSocketFactory, verifier);
        }
    }

    private static CommunicationHandler newHandlerPreference(String handlerProp, String url, String user, String pass, SSLSocketFactory sslSocketFactory, HostnameVerifier verifier) throws InitializationException {
        if (handlerProp == null) {
            throw new NullPointerException();
        }
        if (handlerProp.equals("java")) {
            return new JavaCommunicationHandler(url, user, pass, sslSocketFactory, verifier);
        }
        if (handlerProp.equals("apache")) {
            try {
                return new ApacheCoreCommunicationHandler(url, user, pass, sslSocketFactory, verifier);
            }
            catch (NoClassDefFoundError e) {
                throw new InitializationException("Could not initialize ApacheCommunicationHandler");
            }
        }
        throw new InitializationException("Invalid ifmapj.communication.handler value");
    }
}

