/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.pollingthreads;

import de.esukom.decoit.ifmapclient.config.GeneralConfig;
import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.pollingthreads.FilePollingThread;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;

public class IPTablesULogFilePollingThread
extends FilePollingThread {
    private String[] mIpBlacklist;
    private boolean mLogSkippedEntries;
    private HashMap<String, String> mMonthValues;

    public IPTablesULogFilePollingThread(Properties pr) {
        this.initProperties(pr);
    }

    @Override
    protected void initProperties(Properties props) {
        super.initProperties(props);
        this.initMonthMap();
        this.mIpBlacklist = props.getProperty("iptables.iplist.blacklist").split(",");
        IfMapClient.LOGGER.config("reading in ip-blacklist from enforcement.properties...");
        if (this.mIpBlacklist == null || this.mIpBlacklist.length < 1) {
            IfMapClient.LOGGER.config("no ip-addresses defined in configuration for blacklist");
        }
        int i = 0;
        while (i < this.mIpBlacklist.length) {
            IfMapClient.LOGGER.config("entry [" + i + "] on blacklist has ip-address: " + this.mIpBlacklist[i]);
            ++i;
        }
        this.mLogSkippedEntries = Toolbox.getBoolPropertyWithDefault("iptables.log.skippedentries", false, props);
    }

    @Override
    protected ArrayList<HashMap<String, String>> readFile() {
        int currentLineInSingleEntry = 0;
        int currentCycleLineNumber = 0;
        BufferedReader input = null;
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        HashMap<String, String> tempEventData = new HashMap<String, String>();
        try {
            try {
                input = new BufferedReader(new FileReader(this.file), 1);
                String line = null;
                String entryDate = null;
                boolean skipCurrentEntry = false;
                while ((line = input.readLine()) != null) {
                    if (this.isFirstStart) {
                        ++this.lastEntryLineNumber;
                    }
                    if (!(this.isFirstStart | ++currentCycleLineNumber > this.lastEntryLineNumber)) continue;
                    if (!skipCurrentEntry) {
                        if (!tempEventData.isEmpty()) {
                            result.add((HashMap)tempEventData.clone());
                        }
                    } else {
                        skipCurrentEntry = false;
                    }
                    tempEventData.clear();
                    currentLineInSingleEntry = 0;
                    Matcher ip4Matcher = Toolbox.getRegExPattern("(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9])[.]){3}(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9]))").matcher(line);
                    if (ip4Matcher.find()) {
                        if (this.inBlacklist(ip4Matcher.group())) {
                            skipCurrentEntry = true;
                            if (this.mLogSkippedEntries) {
                                IfMapClient.LOGGER.warning("current entry is inside ip-blacklist [" + ip4Matcher.group() + "]...will now skip this entry");
                            }
                        }
                    } else {
                        skipCurrentEntry = true;
                        IfMapClient.LOGGER.warning("could not find valid IP4-address in current entry...will now skip this entry");
                    }
                    if (skipCurrentEntry) continue;
                    Matcher timestampMatcher = Toolbox.getRegExPattern("\\w*\\s*\\d*\\s\\d*\\:\\d*:\\d*").matcher(line);
                    if (timestampMatcher.find()) {
                        String newLine;
                        entryDate = this.rearrangeDate(String.valueOf(Toolbox.getCurrentYear()) + "/" + timestampMatcher.group());
                        line = newLine = line.replaceFirst("\\w*\\s*\\d*\\s\\d*\\:\\d*:\\d*", entryDate);
                    } else {
                        skipCurrentEntry = true;
                        IfMapClient.LOGGER.warning("could not find timestamp in current entry...will now skip this entry");
                    }
                    if (!GeneralConfig.APPLICATION_MESSAGING_SENDOLD) {
                        if (!Toolbox.getCalendarFromString(entryDate).after(Toolbox.getCalendarFromString(Toolbox.sClientStartTime))) continue;
                        tempEventData.put(new Integer(currentLineInSingleEntry).toString(), line);
                        ++currentLineInSingleEntry;
                        continue;
                    }
                    tempEventData.put(new Integer(currentLineInSingleEntry).toString(), line);
                }
                if (!tempEventData.isEmpty() & !skipCurrentEntry) {
                    result.add(tempEventData);
                }
                if (!this.isFirstStart) {
                    this.lastEntryLineNumber = currentCycleLineNumber;
                } else {
                    this.isFirstStart = false;
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                IfMapClient.exit("error while opening ip-tables ulog-file...the file does not exists, please check your configuration");
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    IfMapClient.exit("error while closing input buffer after trying to read iptables ulog-file");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                IfMapClient.exit("I/O error while reading iptables ulog-file");
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    IfMapClient.exit("error while closing input buffer after trying to read iptables ulog-file");
                }
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                IfMapClient.exit("error while closing input buffer after trying to read iptables ulog-file");
            }
        }
        return result;
    }

    private void initMonthMap() {
        this.mMonthValues = new HashMap();
        this.mMonthValues.put("Jan", "01");
        this.mMonthValues.put("Feb", "02");
        this.mMonthValues.put("Mar", "03");
        this.mMonthValues.put("Apr", "04");
        this.mMonthValues.put("May", "05");
        this.mMonthValues.put("Jun", "06");
        this.mMonthValues.put("Jul", "07");
        this.mMonthValues.put("Aug", "08");
        this.mMonthValues.put("Sep", "09");
        this.mMonthValues.put("Oct", "10");
        this.mMonthValues.put("Nov", "11");
        this.mMonthValues.put("Dec", "12");
    }

    private String rearrangeDate(String currentDate) {
        String[] date = new String[]{currentDate.substring(0, 4), this.mMonthValues.get(currentDate.substring(5, 8)), currentDate.substring(9, 11)};
        if (date[2].startsWith(" ")) {
            date[2] = date[2].replaceFirst(" ", "0");
        }
        String timestamp = currentDate.substring(12, currentDate.length());
        return String.valueOf(date[0]) + "-" + date[1] + "-" + date[2] + " " + timestamp;
    }

    private boolean inBlacklist(String ip) {
        int i = 0;
        while (i < this.mIpBlacklist.length) {
            if (this.mIpBlacklist[i].equals(ip)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

