/*
 * Decompiled with CFR 0.152.
 */
package util;

import de.fhhannover.inform.trust.ifmapj.binding.IfmapStrings;
import de.fhhannover.inform.trust.ifmapj.exception.MarshalException;
import de.fhhannover.inform.trust.ifmapj.log.IfmapJLog;
import de.fhhannover.inform.trust.ifmapj.messages.NamespaceDeclarationHolder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import util.Pair;

public class DomHelpers {
    private static final DocumentBuilderFactory sDocumentBuilderFactory;
    private static final DocumentBuilder sDocumentBuilder;
    private static final TransformerFactory sTransformerFactory;

    public static final DocumentBuilder newDocumentBuilder() {
        try {
            return sDocumentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            IfmapJLog.error(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public static final Element createNonNsElement(Document doc, String name) {
        return doc.createElementNS(null, name);
    }

    public static final void addAttribute(Element el, String name, String val) {
        el.setAttributeNS(null, name, val);
    }

    public static final void addXmlNamespaceDeclarations(NamespaceDeclarationHolder nsh, Element to) {
        for (Pair<String, String> nsDecl : nsh.getNamespaceDeclarations()) {
            String name = "xmlns";
            if (((String)nsDecl.first).length() > 0) {
                name = name + ":" + (String)nsDecl.first;
            }
            String value = (String)nsDecl.second;
            to.setAttributeNS("http://www.w3.org/2000/xmlns/", name, value);
        }
    }

    public static final String makeRequestFQName(String name) {
        return "ifmap:" + name;
    }

    public static final boolean elementMatches(Element el, String elname) {
        return DomHelpers.elementMatches(el, elname, IfmapStrings.NO_URI);
    }

    public static final boolean elementMatches(Element e, String name, String uri) {
        return name.equals(e.getLocalName()) && (uri == null && e.getNamespaceURI() == null || uri != null && uri.equals(e.getNamespaceURI()));
    }

    public static final List<Element> getChildElements(Element e) {
        ArrayList<Element> ret = new ArrayList<Element>();
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            ret.add((Element)child);
        }
        return ret;
    }

    public static final Element findElementInChildren(Node node, String name, String uri) {
        NodeList children = node.getChildNodes();
        Element ret = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1 || !DomHelpers.elementMatches((Element)n, name, uri)) continue;
            ret = (Element)n;
            break;
        }
        return ret;
    }

    public static final Document deepCopy(Element child) {
        Document mdDoc = sDocumentBuilder.newDocument();
        Element el = (Element)mdDoc.importNode(child, true);
        mdDoc.appendChild(el);
        return mdDoc;
    }

    public static final InputStream toInputStream(Document doc) throws MarshalException {
        Transformer trans;
        try {
            trans = sTransformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            IfmapJLog.error("Oh oh.... [" + e.getMessage() + "]");
            throw new MarshalException(e.getMessage());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        byte[] marshalled = null;
        doc.setXmlStandalone(true);
        DOMSource source = new DOMSource(doc);
        try {
            trans.transform(source, result);
        }
        catch (TransformerException e) {
            IfmapJLog.error("Oh oh.... [" + e.getMessage() + "]");
            throw new MarshalException(e.getMessage());
        }
        try {
            baos.flush();
        }
        catch (IOException e) {
            IfmapJLog.error("Oh oh.... [" + e.getMessage() + "]");
            throw new MarshalException(e.getMessage());
        }
        marshalled = baos.toByteArray();
        return new ByteArrayInputStream(marshalled);
    }

    static {
        sTransformerFactory = TransformerFactory.newInstance();
        sDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
        sDocumentBuilderFactory.setNamespaceAware(true);
        sDocumentBuilder = DomHelpers.newDocumentBuilder();
    }
}

