/*
 * Decompiled with CFR 0.152.
 */
package de.fhhannover.inform.trust.ifmapj.messages;

import de.fhhannover.inform.trust.ifmapj.exception.IfmapErrorResult;
import de.fhhannover.inform.trust.ifmapj.exception.MarshalException;
import de.fhhannover.inform.trust.ifmapj.exception.UnmarshalException;
import de.fhhannover.inform.trust.ifmapj.messages.PurgePublisherRequest;
import de.fhhannover.inform.trust.ifmapj.messages.Request;
import de.fhhannover.inform.trust.ifmapj.messages.RequestHandler;
import de.fhhannover.inform.trust.ifmapj.messages.Requests;
import de.fhhannover.inform.trust.ifmapj.messages.Result;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DomHelpers;

class PurgePublisherRequestHandler
implements RequestHandler<PurgePublisherRequest> {
    PurgePublisherRequestHandler() {
    }

    @Override
    public Element toElement(Request req, Document doc) throws MarshalException {
        Requests.Helpers.checkRequestType(req, this);
        PurgePublisherRequest ppr = (PurgePublisherRequest)req;
        String pId = ppr.getPublisherId();
        if (pId == null || pId.length() == 0) {
            throw new MarshalException("No ifmap-publisher-id for purgePublisher set");
        }
        Element ret = doc.createElementNS(Requests.Helpers.baseNsUri(), DomHelpers.makeRequestFQName("purgePublisher"));
        DomHelpers.addAttribute(ret, "ifmap-publisher-id", ppr.getPublisherId());
        Requests.Helpers.addSessionId(ret, req);
        return ret;
    }

    @Override
    public Result fromElement(Element res) throws UnmarshalException, IfmapErrorResult {
        Requests.Helpers.checkSimpleResult(res, "purgePublisherReceived");
        return null;
    }

    @Override
    public Class<PurgePublisherRequest> handles() {
        return PurgePublisherRequest.class;
    }
}

