/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.pollingthreads;

import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.pollingthreads.PollingThread;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class SnortSqlPollingThread
extends PollingThread {
    private String mSnortDatabaseName;
    private String mSnortDatabaseHost;
    private String mSnortDatabaseUser;
    private String mSnortDatabasePass;
    private Connection mConnect = null;
    private PreparedStatement mPrepStatement = null;
    private int mLastCid = 0;
    private final String mRawQuery = "SELECT event.sid,sensor.hostname,event.cid,event.timestamp,signature.sig_name,signature.sig_priority,sig_class.sig_class_name,inet_ntoa(iphdr.ip_src),tcphdr.tcp_sport,inet_ntoa(iphdr.ip_dst),tcphdr.tcp_dport,iphdr.ip_ver,reference_system.ref_system_name,reference.ref_tag FROM event INNER JOIN signature ON event.signature = signature.sig_id  LEFT JOIN sig_reference ON sig_reference.sig_id = signature.sig_id INNER JOIN sig_class ON signature.sig_class_id = sig_class.sig_class_id LEFT JOIN reference ON sig_reference.ref_id = reference.ref_id LEFT JOIN reference_system ON reference.ref_system_id = reference_system.ref_system_id INNER JOIN iphdr ON event.cid = iphdr.cid LEFT JOIN tcphdr ON event.cid = tcphdr.cid INNER JOIN sensor ON event.sid = sensor.sid WHERE event.cid > ? ORDER BY event.cid";

    public SnortSqlPollingThread(Properties pr) {
        this.initProperties(pr);
        this.initDatabaseConnection(this.mSnortDatabaseHost, this.mSnortDatabaseName, this.mSnortDatabaseUser, this.mSnortDatabasePass);
        try {
            this.mPrepStatement = this.mConnect.prepareStatement("SELECT event.sid,sensor.hostname,event.cid,event.timestamp,signature.sig_name,signature.sig_priority,sig_class.sig_class_name,inet_ntoa(iphdr.ip_src),tcphdr.tcp_sport,inet_ntoa(iphdr.ip_dst),tcphdr.tcp_dport,iphdr.ip_ver,reference_system.ref_system_name,reference.ref_tag FROM event INNER JOIN signature ON event.signature = signature.sig_id  LEFT JOIN sig_reference ON sig_reference.sig_id = signature.sig_id INNER JOIN sig_class ON signature.sig_class_id = sig_class.sig_class_id LEFT JOIN reference ON sig_reference.ref_id = reference.ref_id LEFT JOIN reference_system ON reference.ref_system_id = reference_system.ref_system_id INNER JOIN iphdr ON event.cid = iphdr.cid LEFT JOIN tcphdr ON event.cid = tcphdr.cid INNER JOIN sensor ON event.sid = sensor.sid WHERE event.cid > ? ORDER BY event.cid");
        }
        catch (SQLException e) {
            e.printStackTrace();
            IfMapClient.exit("snort-sql-polling-thread encountered an error while building prepared db-statement!");
        }
    }

    @Override
    protected void initProperties(Properties props) {
        this.mSnortDatabaseHost = props.getProperty("snort.database.host", null);
        this.mSnortDatabaseName = props.getProperty("snort.database.name", null);
        this.mSnortDatabaseUser = props.getProperty("snort.database.user", null);
        this.mSnortDatabasePass = props.getProperty("snort.database.pass", null);
        if (this.mSnortDatabaseHost == null || this.mSnortDatabaseHost.length() == 0) {
            IfMapClient.exit("error while initializing SnortSqlPolling Thread - property DATABASE-HOST cannot be null or empty!");
        } else if (this.mSnortDatabaseName == null || this.mSnortDatabaseName.length() == 0) {
            IfMapClient.exit("error while initializing SnortSqlPolling Thread: - property DATABASE-NAME cannot be null or empty!");
        } else if (this.mSnortDatabaseUser == null || this.mSnortDatabaseUser.length() == 0) {
            IfMapClient.exit("error while initializing SnortSqlPolling Thread - property DATABASE-USER cannot be null or empty!");
        } else if (this.mSnortDatabasePass == null || this.mSnortDatabasePass.length() == 0) {
            IfMapClient.exit("error while initializing SnortSqlPolling Thread - property DATABASE-PASS cannot be null or empty!");
        }
    }

    private void initDatabaseConnection(String host, String name, String user, String pass) {
        IfMapClient.LOGGER.config("initalizing snort-database connection with host " + host + " and name " + name + " as user " + user + "...");
        try {
            Class.forName("com.mysql.jdbc.Driver");
            this.mConnect = DriverManager.getConnection("jdbc:mysql://" + host + "/" + name, user, pass);
        }
        catch (Exception e) {
            e.printStackTrace();
            IfMapClient.exit("snort-sql-polling-thread encountered an error while connecting to snort-database " + name + " at host " + host + " with user " + user + "...please check your configuration");
        }
    }

    @Override
    public void run() {
        while (this.running) {
            if (this.pausing) continue;
            try {
                IfMapClient.LOGGER.info("checking snort database for updates...");
                this.mConnect.setAutoCommit(false);
                this.mPrepStatement.setInt(1, this.mLastCid);
                ResultSet resultSet = this.mPrepStatement.executeQuery();
                this.mConnect.commit();
                this.notify(resultSet);
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    IfMapClient.exit("snort-sql-polling-thread encountered an error while thread is trying to get some sleep...please be quit ;-)");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                IfMapClient.exit("snort-sql-polling-thread encountered an error while executing the db query");
            }
        }
    }

    @Override
    public void notify(Object o) {
        if (o != null) {
            ResultSet result = (ResultSet)o;
            ArrayList<HashMap<String, String>> resultList = this.getResultList(result);
            if (resultList != null && resultList.size() > 0) {
                this.pausing = true;
                this.mLastCid = new Integer(resultList.get(resultList.size() - 1).get("cid"));
                this.setChanged();
                this.notifyObservers(resultList);
            } else {
                IfMapClient.LOGGER.info("no new entries in snort-database, not calling observer");
            }
        } else {
            IfMapClient.LOGGER.warning("retrieved snort-database result is null, not calling observer");
        }
    }

    private ArrayList<HashMap<String, String>> getResultList(ResultSet resultSet) {
        ArrayList<HashMap<String, String>> resultList;
        block8: {
            block9: {
                int numColumns = 0;
                String[] columnNames = null;
                resultList = new ArrayList<HashMap<String, String>>();
                if (resultSet == null) break block9;
                try {
                    numColumns = resultSet.getMetaData().getColumnCount();
                    columnNames = new String[numColumns];
                    int i = 1;
                    while (i < numColumns + 1) {
                        String columnName;
                        columnNames[i - 1] = columnName = resultSet.getMetaData().getColumnName(i);
                        ++i;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                try {
                    while (resultSet.next()) {
                        HashMap<String, String> newEntry = new HashMap<String, String>();
                        if (columnNames != null) {
                            int i = 0;
                            while (i < columnNames.length) {
                                newEntry.put(columnNames[i], resultSet.getString(columnNames[i]));
                                ++i;
                            }
                        }
                        resultList.add(newEntry);
                    }
                    break block8;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    IfMapClient.LOGGER.info("snort-database-polling-thread could not create result from read in database values!");
                }
                break block8;
            }
            IfMapClient.LOGGER.info("snort-database-polling-thread could not create result from read in database values!");
        }
        return resultList;
    }
}

