/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.messaging;

import de.esukom.decoit.ifmapclient.iptables.RulesExecutor;
import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.mappingfactory.EventMappingResult;
import de.esukom.decoit.ifmapclient.mappingfactory.MappingResult;
import de.esukom.decoit.ifmapclient.messaging.IFMAPMessagingFacade;
import de.esukom.decoit.ifmapclient.messaging.PollingClientListEntry;
import java.util.ArrayList;

public class PollingClientList {
    private ArrayList<PollingClientListEntry> mClientList = new ArrayList();

    public ArrayList<PollingClientListEntry> getClientList() {
        return this.mClientList;
    }

    public boolean addNewClientsToClientList(MappingResult[] resultList) {
        boolean entryInserted = false;
        int i = 0;
        while (i < resultList.length) {
            EventMappingResult currentEventResult = (EventMappingResult)resultList[i];
            String currentIp = currentEventResult.getIp();
            PollingClientListEntry newEntry = new PollingClientListEntry(currentIp);
            if (this.insertEntryIfIPNotExists(newEntry)) {
                IfMapClient.LOGGER.info("new client has been added to client list: " + currentIp);
                entryInserted = true;
            } else {
                IfMapClient.LOGGER.info("not added client " + currentIp + " to client list because it already exists! ");
            }
            ++i;
        }
        return entryInserted;
    }

    public void allowClient(String ip) {
        int i = 0;
        while (i < this.getClientList().size()) {
            if (!this.getClientList().get(i).getIPAddress().equals(IFMAPMessagingFacade.getInstance().mapServerIP) && this.getClientList().get(i).isSubscribed() & this.getClientList().get(i).getIPAddress().equals(ip) & !this.getClientList().get(i).isAllowed() & !this.getClientList().get(i).isForceBlocked()) {
                RulesExecutor ipTablesRulesExecutor = RulesExecutor.getInstance();
                ipTablesRulesExecutor.executePredefinedRule((byte)2, new String[]{this.getClientList().get(i).getIPAddress()});
                this.getClientList().get(i).setAllowed(true);
                IfMapClient.LOGGER.info("Client with IP " + this.getClientList().get(i).getIPAddress() + " has been alowed and unblocked!");
            }
            ++i;
        }
    }

    public boolean insertEntryIfIPNotExists(PollingClientListEntry entryToInsert) {
        boolean alreadyExists = false;
        if (this.mClientList != null) {
            int i = 0;
            while (i < this.mClientList.size()) {
                PollingClientListEntry currentEntry = this.mClientList.get(i);
                if (currentEntry.getIPAddress().equals(entryToInsert.getIPAddress())) {
                    alreadyExists = true;
                }
                ++i;
            }
        }
        if (!alreadyExists) {
            this.mClientList.add(entryToInsert);
            return true;
        }
        return false;
    }

    public PollingClientListEntry getEntryByIpString(String ip) {
        if (this.mClientList != null) {
            int i = 0;
            while (i < this.mClientList.size()) {
                if (this.mClientList.get(i).getIPAddress().equals(ip)) {
                    return this.mClientList.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    public ArrayList<PollingClientListEntry> getAllSubscribedEntrys() {
        ArrayList<PollingClientListEntry> newList = new ArrayList<PollingClientListEntry>();
        if (this.mClientList != null) {
            int i = 0;
            while (i < this.mClientList.size()) {
                if (this.mClientList.get(i).isSubscribed()) {
                    newList.add(this.mClientList.get(i));
                }
                ++i;
            }
        }
        if (newList.size() > 0) {
            return newList;
        }
        return null;
    }

    private ArrayList<PollingClientListEntry> getAllBlockedEntrys() {
        ArrayList<PollingClientListEntry> newList = new ArrayList<PollingClientListEntry>();
        if (this.mClientList != null) {
            int i = 0;
            while (i < this.mClientList.size()) {
                if (this.mClientList.get(i).isForceBlocked()) {
                    newList.add(this.mClientList.get(i));
                }
                ++i;
            }
        }
        if (newList.size() > 0) {
            return newList;
        }
        return null;
    }

    public boolean isClientBlocked(String ipAddress) {
        ArrayList<PollingClientListEntry> blockedClients = this.getAllBlockedEntrys();
        if (blockedClients != null) {
            int i = 0;
            while (i < blockedClients.size()) {
                if (blockedClients.get(i).getIPAddress().equals(ipAddress)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isClientBlockedOrAllowed(String ipAddress) {
        if (this.mClientList != null) {
            int i = 0;
            while (i < this.mClientList.size()) {
                if (this.mClientList.get(i).getIPAddress().equals(ipAddress) && (this.mClientList.get(i).isAllowed() || this.mClientList.get(i).isForceBlocked())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

