/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.iptables;

import de.esukom.decoit.ifmapclient.iptables.Rules;
import de.esukom.decoit.ifmapclient.main.IfMapClient;
import java.io.IOException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteWatchdog;

public class RulesExecutor {
    public static final int EXIT_CODE_SUCCESS = 0;
    public static final int EXIT_CODE_ERROR = 1;
    private static RulesExecutor sInstance;
    public final String command = "/sbin/iptables";
    private int mTimeout = 60000;

    private RulesExecutor() {
    }

    public static synchronized RulesExecutor getInstance() {
        if (sInstance == null) {
            sInstance = new RulesExecutor();
        }
        return sInstance;
    }

    public boolean executePredefinedRule(byte ruleType, String[] arg) {
        IfMapClient.LOGGER.info("[IPTABLES] -> executing predefined command...");
        CommandLine cmdLine = new CommandLine("/sbin/iptables");
        String[] ruleParams = Rules.getPredefindedRuleParameters(ruleType, arg);
        if (ruleParams != null) {
            int i = 0;
            while (i < ruleParams.length) {
                cmdLine.addArgument(ruleParams[i]);
                ++i;
            }
            DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
            ExecuteWatchdog watchdog = new ExecuteWatchdog((long)this.mTimeout);
            DefaultExecutor executor = new DefaultExecutor();
            executor.setExitValue(1);
            executor.setWatchdog(watchdog);
            try {
                executor.execute(cmdLine, (ExecuteResultHandler)resultHandler);
            }
            catch (ExecuteException e) {
                IfMapClient.LOGGER.warning("[IPTABLES] -> error while executing predefined command: execute-exception occured!");
                return false;
            }
            catch (IOException e) {
                IfMapClient.LOGGER.warning("[IPTABLES] -> error while executing predefined command: io-exception occured!");
                return false;
            }
            try {
                resultHandler.waitFor();
                int exitCode = resultHandler.getExitValue();
                IfMapClient.LOGGER.warning("[IPTABLES] -> command executed, exit-code is: " + exitCode);
                switch (exitCode) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                }
                return false;
            }
            catch (InterruptedException e) {
                IfMapClient.LOGGER.warning("[IPTABLES] -> error while executing predefined command: interrupted-exception occured!");
                return false;
            }
        }
        IfMapClient.LOGGER.warning("[IPTABLES] -> error while excuting predefined command: rule-parameters-list is null!");
        return false;
    }
}

