   /*            
    * SqlPollingThread.java        0.1.4 12/02/16
    * 
    * DEVELOPED BY DECOIT GMBH WITHIN THE ESUKOM-PROJECT:
    * http://www.decoit.de/
    * http://www.esukom.de/cms/front_content.php?idcat=10&lang=1
    * 
    * DERIVED FROM  THE DHCP-IFMAP-CLIENT-IMPLEMENTATION DEVELOPED BY 
    * FHH/TRUST WITHIN THE IRON-PROJECT:
    * http://trust.inform.fh-hannover.de/joomla/
    * 
    * Licensed to the Apache Software Foundation (ASF) under one 
    * or more contributor license agreements.  See the NOTICE file 
    * distributed with this work for additional information 
    * regarding copyright ownership.  The ASF licenses this file 
    * to you under the Apache License, Version 2.0 (the 
    * "License"); you may not use this file except in compliance 
    * with the License.  You may obtain a copy of the License at 
    * 
    *   http://www.apache.org/licenses/LICENSE-2.0 
    * 
    * Unless required by applicable law or agreed to in writing, 
    * software distributed under the License is distributed on an 
    * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY 
    * KIND, either express or implied.  See the License for the 
    * specific language governing permissions and limitations 
    * under the License. 
    */

package de.esukom.decoit.ifmapclient.pollingthreads;

import de.esukom.decoit.ifmapclient.main.IfMapClient;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;



/**
 * Abstract base Class for reading and polling DB entries
 * 
 * @version 0.3
 * @author Marcel Jahnke, DECOIT GmbH
 * @author Dennis Dunekacke, Decoit GmbH
 */
public abstract class SqlPollingThread extends PollingThread {
    public String databaseName;
    public String databaseHost;
    public String databaseUser;
    public String databasePass;

    // database-parameters
    public Connection connect = null;
    public PreparedStatement prepStatement = null;

    // SQL statement, used for building a prepared statement
    public String rawQuery;

    // id to begin with when executing database-statement
    public int lastCid = 0; // startup-value

    // the name of the ID Field
    public String identFieldName;

    @Override
    protected void initProperties(Properties props) {
        // load properties
        databaseHost = props.getProperty("database.host", null);
        databaseName = props.getProperty("database.name", null);
        databaseUser = props.getProperty("database.user", null);
        databasePass = props.getProperty("database.pass", null);

        // check properties
        if (databaseHost == null || databaseHost.length() == 0) {
            IfMapClient
                    .exit("error while initializing SqlPolling Thread - property DATABASE-HOST cannot be null or empty!");
        } else if (databaseName == null || databaseName.length() == 0) {
            IfMapClient
                    .exit("error while initializing SqlPolling Thread: - property DATABASE-NAME cannot be null or empty!");
        } else if (databaseUser == null || databaseUser.length() == 0) {
            IfMapClient
                    .exit("error while initializing SqlPolling Thread - property DATABASE-USER cannot be null or empty!");
        } else if (databasePass == null || databasePass.length() == 0) {
            IfMapClient
                    .exit("error while initializing SqlPolling Thread - property DATABASE-PASS cannot be null or empty!");
        }
    }

    /**
     * initializes the database connection
     * 
     * @param host
     *            host IP-Address
     * @param name
     *            database name
     * @param user
     *            database user name
     * @param pass
     *            database password
     */
    protected void initDatabaseConnection(String host, String name, String user, String pass) {
        // initialize DB-connection
        IfMapClient.LOGGER.config("initalizing database connection with host " + host
                + " and name " + name + " as user " + user + "...");
        try {
            // load the MySQL driver
            Class.forName("com.mysql.jdbc.Driver");

            // Setup the connection with the DB
            connect = DriverManager.getConnection("jdbc:mysql://" + host + "/" + name, user, pass);

        } catch (Exception e) {
            e.printStackTrace();
            IfMapClient
                    .exit("sql-polling-thread encountered an error while connecting to database "
                            + name + " at host " + host + " with user " + user
                            + "...please check your configuration");
        }
    }

    @Override
    public void notify(Object o) {
        if (o != null) {
            // cast passed in object back to DB-result-set
            ResultSet result = (ResultSet) o;

            // create attribute-value pairs from result-set
            ArrayList<HashMap<String, String>> resultList = getResultList(result);

            // in case of new entries, notify observer and pass the new entries
            if (resultList != null && resultList.size() > 0) {
                // hold DB-Thread
                pausing = true;

                // set internal database id (cid) of last result in list, used
                // to
                // determine query-starting point for next DB-poll-cycle lastCid
                // =
                lastCid = new Integer(resultList.get(resultList.size() - 1).get(identFieldName))
                        .intValue();

                // notify the observer and pass new entries
                setChanged();
                notifyObservers(resultList);
            } else {
                IfMapClient.LOGGER.info("no new entries in " + databaseName
                        + "-database, not calling observer");
            }
        } else {
            IfMapClient.LOGGER
                    .warning("retrieved snort-database result is null, not calling observer");
        }
    }

    @Override
    public void run() {
        /**
         * thread-run()-method
         */
        while (running) {
            if (!pausing) {
                try {
                    IfMapClient.LOGGER.info("checking " + databaseName
                            + " database for updates...");
                    connect.setAutoCommit(false);

                    // set current cid parameter to prepared statement
                    // logger.info("executing db-query with cId: " + lastCid);
                    System.out.println(rawQuery);
                    prepStatement.setInt(1, lastCid);
                    ResultSet resultSet = prepStatement.executeQuery();
                    connect.commit();

                    // analyze result-set and notify observers
                    notify(resultSet);

                    // sleep for a while
                    try {
                        Thread.sleep(sleepTime);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                        IfMapClient
                                .exit("sql-polling-thread encountered an error while thread is trying to get some sleep...please be quit ;-)");
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    IfMapClient
                            .exit("sql-polling-thread encountered an error while executing the db query");
                }
            }
        }
    }

    /**
     * map result-set from database-query to a list of attribute-value-pairs
     * (realized as ArrayList of HashMaps for now)
     * 
     * @param resultSet
     *            result-set of database query
     * 
     * @return ArrayList list containing the DB-Entries as HashMaps
     */
    protected abstract ArrayList<HashMap<String, String>> getResultList(ResultSet resultSet);
}
