   /*            
    * RadiusSqlPollingThread.java        0.1.4 12/02/16
    * 
    * DEVELOPED BY DECOIT GMBH WITHIN THE ESUKOM-PROJECT:
    * http://www.decoit.de/
    * http://www.esukom.de/cms/front_content.php?idcat=10&lang=1
    * 
    * DERIVED FROM  THE DHCP-IFMAP-CLIENT-IMPLEMENTATION DEVELOPED BY 
    * FHH/TRUST WITHIN THE IRON-PROJECT:
    * http://trust.inform.fh-hannover.de/joomla/
    * 
    * Licensed to the Apache Software Foundation (ASF) under one 
    * or more contributor license agreements.  See the NOTICE file 
    * distributed with this work for additional information 
    * regarding copyright ownership.  The ASF licenses this file 
    * to you under the Apache License, Version 2.0 (the 
    * "License"); you may not use this file except in compliance 
    * with the License.  You may obtain a copy of the License at 
    * 
    *   http://www.apache.org/licenses/LICENSE-2.0 
    * 
    * Unless required by applicable law or agreed to in writing, 
    * software distributed under the License is distributed on an 
    * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY 
    * KIND, either express or implied.  See the License for the 
    * specific language governing permissions and limitations 
    * under the License. 
    */

package de.esukom.decoit.ifmapclient.pollingthreads;

import de.esukom.decoit.ifmapclient.main.IfMapClient;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;

/**
 * Class for the SqlPolling. 
 * 
 * @version 0.1.4
 * @author Marcel Jahnke, Decoit GmbH
 *
 */

public class RadiusSqlPollingThread extends SqlPollingThread {
    private int mLastCid2 = 0;
    private String mIdentFieldName2 = "id";
    private ArrayList<Integer> mNotClossedSessionAcct = new ArrayList<Integer>();

    public RadiusSqlPollingThread(Properties pr) {
        // initialize properties
        super.identFieldName = "radacctid";
        initProperties(pr);
        initDatabaseConnection(databaseHost, databaseName, databaseUser, databasePass);
    }

    /**
     * map result-set from database-query to a list of attribute-value-pairs
     * (realized as ArrayList of HashMaps for now)
     * 
     * @param resultSet
     *            result-set of database query
     * 
     * @return ArrayList list containing the DB-Entries as HashMaps
     */
    @Override
    protected ArrayList<HashMap<String, String>> getResultList(ResultSet resultSet) {
        int numColumns = 0;
        String[] columnNames = null;
        ArrayList<HashMap<String, String>> resultList = new ArrayList<HashMap<String, String>>();

        if (resultSet != null) {
            try {
                numColumns = resultSet.getMetaData().getColumnCount();

                // Get the column names; column indices start from 1
                columnNames = new String[numColumns];
                for (int i = 1; i < numColumns + 1; i++) {
                    String columnName = resultSet.getMetaData().getColumnName(i);
                    columnNames[i - 1] = columnName;
                }
            } catch (SQLException e) {
                e.printStackTrace();
            }
            // create new event-object from result-set-entries
            try {
                while (resultSet.next()) {
                    HashMap<String, String> newEntry = new HashMap<String, String>();
                    if (columnNames != null) {
                        for (int i = 0; i < columnNames.length; i++) {
                            newEntry.put(columnNames[i], resultSet.getString(columnNames[i]));

                            if (columnNames[i].equalsIgnoreCase("acctstoptime")) {
                                if (resultSet.getString(columnNames[i]) == null
                                        & !(mNotClossedSessionAcct.contains(Integer
                                                .valueOf(resultSet.getString("radacctid"))))) {
                                    mNotClossedSessionAcct.add(Integer.valueOf(resultSet
                                            .getString("radacctid")));
                                    System.out.println(resultSet.getString("radacctid"));
                                } else if (resultSet.getString(columnNames[i]) != null) {
                                    mNotClossedSessionAcct.remove(Integer.valueOf(resultSet
                                            .getString("radacctid")));
                                    System.out.println(resultSet.getString("radacctid"));
                                }
                            }
                        }
                    }
                    resultList.add(newEntry);
                }

            } catch (SQLException e) {
                e.printStackTrace();
                IfMapClient.LOGGER
                        .info("snort-database-polling-thread could not create result from read in database values!");
            }
        } else {
            IfMapClient.LOGGER
                    .info("snort-database-polling-thread could not create result from read in database values!");
        }

        return resultList;
    }

    @Override
    public void run() {
        /**
         * thread-run()-method
         */
        while (super.running) {
            if (!super.pausing) {
                ArrayList<Object> resultListArray = new ArrayList<Object>();
                try {
                    IfMapClient.LOGGER.info("checking " + super.databaseName
                            + " database for updates...");
                    super.connect.setAutoCommit(false);
                    // Query the radacct table (Accounting)

                    // query all not closed accountings again
                    final StringBuffer additionalQuery = new StringBuffer();
                    if (mNotClossedSessionAcct.size() > 0) {
                        for (int i = 0; i < mNotClossedSessionAcct.size(); i++) {
                            additionalQuery.append("OR radacctid=");
                            additionalQuery.append(mNotClossedSessionAcct.get(i));
                            additionalQuery.append(" ");

                        }
                    } else {
                        additionalQuery.append("");
                    }

                    super.rawQuery = "Select radacctid,acctsessionid,username,nasipaddress,acctstarttime,acctstoptime,"
                            + "acctsessiontime From radacct WHERE radacctid > ? "
                            + additionalQuery.toString() + "ORDER BY radacctid ASC;";
                    try {
                        super.prepStatement = super.connect.prepareStatement(super.rawQuery);
                    } catch (SQLException e) {
                        e.printStackTrace();
                        IfMapClient
                                .exit("radius-sql-polling-thread encountered an error while building prepared db-statement!");
                    }
                    // set current cid parameter to prepared statement
                    // logger.info("executing db-query with cId: " + lastCid);
                    super.prepStatement.setInt(1, super.lastCid);
                    resultListArray.add(super.prepStatement.executeQuery());
                    super.connect.commit();

                    super.rawQuery = "SELECT id, username, reply, authdate FROM radpostauth WHERE id > ?;";
                    try {
                        super.prepStatement = super.connect.prepareStatement(super.rawQuery);
                    } catch (SQLException e) {
                        e.printStackTrace();
                        IfMapClient
                                .exit("radius-sql-polling-thread encountered an error while building prepared db-statement!");
                    }
                    super.prepStatement.setInt(1, mLastCid2);
                    resultListArray.add(super.prepStatement.executeQuery());
                    super.connect.commit();

                    // analyze result-set and notify observers
                    notify(resultListArray);

                    // sleep for a while
                    try {
                        Thread.sleep(super.sleepTime);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                        IfMapClient
                                .exit("sql-polling-thread encountered an error while thread is trying to get some sleep...please be quit ;-)");
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    IfMapClient
                            .exit("sql-polling-thread encountered an error while executing the db query");
                }
            }
        }
    }

    public void notify(ArrayList<Object> o) {
        ArrayList<HashMap<String, String>> resultList = new ArrayList<HashMap<String, String>>();
        if (o != null) {
            ArrayList<HashMap<String, String>> temp = new ArrayList<HashMap<String, String>>();
            for (int i = 0; i < o.size(); i++) {

                // cast passed in object back to DB-result-set
                ResultSet result = (ResultSet) o.get(i);

                // create attribute-value pairs from result-set
                temp = getResultList(result);
                for (int j = 0; j < temp.size(); j++) {
                    resultList.add(temp.get(j));
                }
            }
            // in case of new entries, notify observer and pass the new entries
            if (resultList != null && resultList.size() > 0) {
                // hold DB-Thread
                pausing = true;

                // set internal database id (cid) of last result in list, used
                // to
                // determine query-starting point for next DB-poll-cycle lastCid
                //
                ArrayList<Integer> findLastCidAcc = new ArrayList<Integer>();
                ArrayList<Integer> findLastCidAuth = new ArrayList<Integer>();
                for (int i = 0; i < resultList.size(); i++) {
                    if (resultList.get(i).containsKey("acctstarttime")) {
                        findLastCidAcc.add(Integer.valueOf(resultList.get(i).get(identFieldName)));
                    } else {
                        findLastCidAuth
                                .add(Integer.valueOf(resultList.get(i).get(mIdentFieldName2)));
                    }
                }
                Collections.sort(findLastCidAcc);
                Collections.sort(findLastCidAuth);
                if (findLastCidAcc.size() > 0)
                    lastCid = findLastCidAcc.get(findLastCidAcc.size() - 1);
                if (findLastCidAuth.size() > 0)
                    mLastCid2 = findLastCidAuth.get(findLastCidAuth.size() - 1);

                // notify the observer and pass new entries
                setChanged();
                notifyObservers(resultList);
            } else {
                IfMapClient.LOGGER.info("no new entries in " + databaseName
                        + "-database, not calling observer");
            }
        } else {
            IfMapClient.LOGGER
                    .warning("retrieved RADIUS-database result is null, not calling observer");
        }
    }

}
