/*
 * Decompiled with CFR 0.152.
 */
package de.fhhannover.inform.trust.ifmapj.metadata;

import de.fhhannover.inform.trust.ifmapj.log.IfmapJLog;
import de.fhhannover.inform.trust.ifmapj.metadata.Cardinality;
import de.fhhannover.inform.trust.ifmapj.metadata.EnforcementAction;
import de.fhhannover.inform.trust.ifmapj.metadata.EventType;
import de.fhhannover.inform.trust.ifmapj.metadata.LocationInformation;
import de.fhhannover.inform.trust.ifmapj.metadata.Significance;
import de.fhhannover.inform.trust.ifmapj.metadata.StandardIfmapMetadataFactory;
import de.fhhannover.inform.trust.ifmapj.metadata.WlanSecurityType;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class StandardIfmapMetadataFactoryImpl
implements StandardIfmapMetadataFactory {
    private DocumentBuilder mDocumentBuilder;

    public StandardIfmapMetadataFactoryImpl() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            this.mDocumentBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            IfmapJLog.error("Could not get DocumentBuilder instance [" + e.getMessage() + "]");
            throw new RuntimeException(e);
        }
    }

    @Override
    public Document createIpMac(String startTime, String endTime, String dhcpServer) {
        Document doc = this.createStdSingleElementDocument("ip-mac", Cardinality.multiValue);
        Element root = (Element)doc.getFirstChild();
        this.appendTextElementIfNotNull(doc, root, "start-time", startTime);
        this.appendTextElementIfNotNull(doc, root, "end-time", endTime);
        this.appendTextElementIfNotNull(doc, root, "dhcp-server", dhcpServer);
        return doc;
    }

    @Override
    public Document createIpMac() {
        return this.createIpMac(null, null, null);
    }

    @Override
    public Document createArMac() {
        return this.createStdSingleElementDocument("access-request-mac", Cardinality.singleValue);
    }

    @Override
    public Document createArDev() {
        return this.createStdSingleElementDocument("access-request-device", Cardinality.singleValue);
    }

    @Override
    public Document createArIp() {
        return this.createStdSingleElementDocument("access-request-ip", Cardinality.singleValue);
    }

    @Override
    public Document createAuthAs() {
        return this.createStdSingleElementDocument("authenticated-as", Cardinality.singleValue);
    }

    @Override
    public Document createAuthBy() {
        return this.createStdSingleElementDocument("authenticated-by", Cardinality.singleValue);
    }

    @Override
    public Document createDevIp() {
        return this.createStdSingleElementDocument("device-ip", Cardinality.singleValue);
    }

    @Override
    public Document createDiscoveredBy() {
        return this.createStdSingleElementDocument("discovered-by", Cardinality.singleValue);
    }

    @Override
    public Document createRole(String name, String administrativeDomain) {
        Document doc = this.createStdSingleElementDocument("role", Cardinality.multiValue);
        Element root = (Element)doc.getFirstChild();
        this.createAndAppendTextElementCheckNull(doc, root, "name", name);
        this.appendTextElementIfNotNull(doc, root, "administrative-domain", administrativeDomain);
        return doc;
    }

    @Override
    public Document createRole(String name) {
        return this.createRole(name, null);
    }

    @Override
    public Document createDevAttr(String name) {
        Document doc = this.createStdSingleElementDocument("device-attribute", Cardinality.multiValue);
        Element root = (Element)doc.getFirstChild();
        this.createAndAppendTextElementCheckNull(doc, root, "name", name);
        return doc;
    }

    @Override
    public Document createCapability(String name, String administrativeDomain) {
        Document doc = this.createStdSingleElementDocument("capability", Cardinality.multiValue);
        Element root = (Element)doc.getFirstChild();
        this.createAndAppendTextElementCheckNull(doc, root, "name", name);
        this.appendTextElementIfNotNull(doc, root, "administrative-domain", administrativeDomain);
        return doc;
    }

    @Override
    public Document createCapability(String name) {
        return this.createCapability(name, null);
    }

    @Override
    public Document createDevChar(String manufacturer, String model, String os, String osVersion, String deviceType, String discoveredTime, String discovererId, String discoveryMethod) {
        Document doc = this.createStdSingleElementDocument("device-characteristic", Cardinality.multiValue);
        Element root = (Element)doc.getFirstChild();
        this.appendTextElementIfNotNull(doc, root, "manufacturer", manufacturer);
        this.appendTextElementIfNotNull(doc, root, "model", model);
        this.appendTextElementIfNotNull(doc, root, "os", os);
        this.appendTextElementIfNotNull(doc, root, "os-version", osVersion);
        this.appendTextElementIfNotNull(doc, root, "device-type", deviceType);
        this.createAndAppendTextElementCheckNull(doc, root, "discovered-time", discoveredTime);
        this.createAndAppendTextElementCheckNull(doc, root, "discoverer-id", discovererId);
        this.createAndAppendTextElementCheckNull(doc, root, "discovery-method", discoveryMethod);
        return doc;
    }

    @Override
    public Document createEnforcementReport(EnforcementAction enforcementAction, String otherTypeDefinition, String enforcementReason) {
        Document doc = this.createStdSingleElementDocument("enforcement-report", Cardinality.multiValue);
        Element root = (Element)doc.getFirstChild();
        this.createAndAppendTextElementCheckNull(doc, root, "enforcement-action", (Object)enforcementAction);
        this.appendTextElementIfNotNull(doc, root, "other-type-definition", otherTypeDefinition);
        this.appendTextElementIfNotNull(doc, root, "enforcement-reason", enforcementReason);
        return doc;
    }

    @Override
    public Document createEvent(String name, String discoveredTime, String discovererId, Integer magnitude, Integer confidence, Significance significance, EventType type, String otherTypeDefinition, String information, String vulnerabilityUri) {
        Document doc = this.createStdSingleElementDocument("event", Cardinality.multiValue);
        Element root = (Element)doc.getFirstChild();
        this.createAndAppendTextElementCheckNull(doc, root, "name", name);
        this.createAndAppendTextElementCheckNull(doc, root, "discovered-time", discoveredTime);
        this.createAndAppendTextElementCheckNull(doc, root, "discoverer-id", discovererId);
        this.createAndAppendTextElementCheckNull(doc, root, "magnitude", magnitude);
        this.createAndAppendTextElementCheckNull(doc, root, "confidence", confidence);
        this.createAndAppendTextElementCheckNull(doc, root, "significance", (Object)significance);
        this.appendTextElementIfNotNull(doc, root, "type", (Object)type);
        this.appendTextElementIfNotNull(doc, root, "other-type-definition", otherTypeDefinition);
        this.appendTextElementIfNotNull(doc, root, "information", information);
        this.appendTextElementIfNotNull(doc, root, "vulnerability-uri", vulnerabilityUri);
        return doc;
    }

    @Override
    public Document createLayer2Information(Integer vlanNum, String vlanName, Integer port, String administrativeDomain) {
        Document doc = this.createStdSingleElementDocument("layer2-information", Cardinality.multiValue);
        Element root = (Element)doc.getFirstChild();
        this.appendTextElementIfNotNull(doc, root, "vlan", vlanNum);
        this.appendTextElementIfNotNull(doc, root, "vlan-name", vlanName);
        this.appendTextElementIfNotNull(doc, root, "port", port);
        this.appendTextElementIfNotNull(doc, root, "administrative-domain", administrativeDomain);
        return doc;
    }

    @Override
    public Document createLocation(List<LocationInformation> locationInformation, String discoveredTime, String discovererId) {
        Document doc = this.createStdSingleElementDocument("location", Cardinality.multiValue);
        Element root = (Element)doc.getFirstChild();
        if (locationInformation == null || locationInformation.size() == 0) {
            throw new NullPointerException("location-information needs to be set for location");
        }
        for (LocationInformation tmpLoc : locationInformation) {
            this.appendElementWithAttributes(doc, root, "location-information", "type", tmpLoc.mType, "value", tmpLoc.mValue);
        }
        this.createAndAppendTextElementCheckNull(doc, root, "discovered-time", discoveredTime);
        this.createAndAppendTextElementCheckNull(doc, root, "discoverer-id", discovererId);
        return doc;
    }

    @Override
    public Document createRequestForInvestigation(String qualifier) {
        Document doc = this.createStdSingleElementDocument("request-for-investigation", Cardinality.multiValue);
        Element root = (Element)doc.getFirstChild();
        if (qualifier != null) {
            root.setAttributeNS(null, "qualifier", qualifier);
        }
        return doc;
    }

    @Override
    public Document createWlanInformation(String ssid, List<WlanSecurityType> ssidUnicastSecurity, WlanSecurityType ssidGroupSecurity, List<WlanSecurityType> ssidManagementSecurity) {
        Document doc = this.createStdSingleElementDocument("wlan-information", Cardinality.singleValue);
        Element root = (Element)doc.getFirstChild();
        Element ssidUniSecEl = null;
        Element ssidMgmtSecEl = null;
        if (ssidUnicastSecurity == null || ssidUnicastSecurity.size() == 0) {
            throw new NullPointerException("ssid-unicast-security to be set for wlan-information");
        }
        if (ssidGroupSecurity == null) {
            throw new NullPointerException("ssid-group-security to be set for wlan-information");
        }
        if (ssidManagementSecurity == null || ssidManagementSecurity.size() == 0) {
            throw new NullPointerException("ssid-management-security to be set for wlan-information");
        }
        this.appendTextElementIfNotNull(doc, root, "ssid", ssid);
        for (WlanSecurityType wlanSec : ssidUnicastSecurity) {
            ssidUniSecEl = this.createAndAppendTextElementCheckNull(doc, root, "ssid-unicast-security", wlanSec.mWlanSecurityType.toString());
            if (wlanSec.mOtherTypeDefinition == null) continue;
            ssidUniSecEl.setAttributeNS(null, "other-type-definition", wlanSec.mOtherTypeDefinition);
        }
        Element grpSecEl = this.createAndAppendTextElementCheckNull(doc, root, "ssid-group-security", ssidGroupSecurity.mWlanSecurityType.toString());
        if (ssidGroupSecurity.mOtherTypeDefinition != null) {
            grpSecEl.setAttributeNS(null, "other-type-definition", ssidGroupSecurity.mOtherTypeDefinition);
        }
        for (WlanSecurityType wlanSec : ssidManagementSecurity) {
            ssidMgmtSecEl = this.createAndAppendTextElementCheckNull(doc, root, "ssid-management-security", wlanSec.mWlanSecurityType.toString());
            if (wlanSec.mOtherTypeDefinition == null) continue;
            ssidMgmtSecEl.setAttributeNS(null, "other-type-definition", wlanSec.mOtherTypeDefinition);
        }
        return doc;
    }

    @Override
    public Document createUnexpectedBehavior(String discoveredTime, String discovererId, Integer magnitude, Integer confidence, Significance significance, String type) {
        Document doc = this.createStdSingleElementDocument("unexpected-behavior", Cardinality.multiValue);
        Element root = (Element)doc.getFirstChild();
        this.createAndAppendTextElementCheckNull(doc, root, "discovered-time", discoveredTime);
        this.createAndAppendTextElementCheckNull(doc, root, "discoverer-id", discovererId);
        this.createAndAppendTextElementCheckNull(doc, root, "magnitude", magnitude);
        this.createAndAppendTextElementCheckNull(doc, root, "confidence", confidence);
        this.createAndAppendTextElementCheckNull(doc, root, "significance", (Object)significance);
        this.appendTextElementIfNotNull(doc, root, "type", type);
        return doc;
    }

    private Document createStdSingleElementDocument(String name, Cardinality card) {
        return this.createSingleElementDocument("meta:" + name, "http://www.trustedcomputinggroup.org/2010/IFMAP-METADATA/2", card);
    }

    private Document createSingleElementDocument(String qualifiedName, String uri, Cardinality cardinality) {
        Document doc = this.mDocumentBuilder.newDocument();
        Element e = doc.createElementNS(uri, qualifiedName);
        e.setAttributeNS(null, "ifmap-cardinality", cardinality.toString());
        doc.appendChild(e);
        return doc;
    }

    private void appendTextElementIfNotNull(Document doc, Element parent, String elName, Object value) {
        if (value == null) {
            return;
        }
        this.createAndAppendTextElementCheckNull(doc, parent, elName, value);
    }

    private Element createAndAppendTextElementCheckNull(Document doc, Element parent, String elName, Object value) {
        if (doc == null || parent == null || elName == null) {
            throw new NullPointerException("bad parameters given");
        }
        if (value == null) {
            throw new NullPointerException("null is not allowed for " + elName + " in " + doc.getFirstChild().getLocalName());
        }
        String valueStr = value.toString();
        if (valueStr == null) {
            throw new NullPointerException("null-string not allowed for " + elName + " in " + doc.getFirstChild().getLocalName());
        }
        Element child = this.createAndAppendElement(doc, parent, elName);
        Text txtCElement = doc.createTextNode(valueStr);
        child.appendChild(txtCElement);
        return child;
    }

    private Element createAndAppendElement(Document doc, Element parent, String elName) {
        Element el = doc.createElementNS(null, elName);
        parent.appendChild(el);
        return el;
    }

    private Element appendElementWithAttributes(Document doc, Element parent, String elName, String ... attrList) {
        if (attrList.length % 2 != 0) {
            throw new RuntimeException("Bad attrList length");
        }
        Element el = this.createAndAppendElement(doc, parent, elName);
        for (int i = 0; i < attrList.length; i += 2) {
            el.setAttributeNS(null, attrList[i], attrList[i + 1]);
        }
        return el;
    }
}

