/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.pollingthreads;

import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.pollingthreads.PollingThread;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Scanner;

public class NagiosSocketPollingThread
extends PollingThread {
    private int mNagiosPort;
    private ServerSocket mProviderSocket;
    private Socket mConnection = null;
    private BufferedReader mBufferReader = null;
    private DataInputStream mIn = null;

    public NagiosSocketPollingThread(Properties pr) {
        this.initProperties(pr);
        IfMapClient.LOGGER.config("initalizing socket for nagios messages which listens on port: " + this.mNagiosPort);
        try {
            this.mProviderSocket = new ServerSocket(this.mNagiosPort);
        }
        catch (IOException e) {
            e.printStackTrace();
            IfMapClient.exit("I/O error while creating server socket for nagios polling-thread");
        }
    }

    @Override
    protected void initProperties(Properties props) {
        this.mNagiosPort = new Integer(props.getProperty("nagios.server.port", "0"));
        if (this.mNagiosPort <= 0) {
            IfMapClient.exit("error while initializing NagiosSocketPolling Thread - property nagiosPort must be above zero");
        }
    }

    private HashMap<String, String> parseLine(String line) {
        if (line != null && line.matches("((\\w+)=(.+);)+")) {
            IfMapClient.LOGGER.fine("incomming line to parse: " + line);
            HashMap<String, String> makrosList = new HashMap<String, String>();
            Scanner scanner = new Scanner(line);
            scanner.useDelimiter(";");
            while (scanner.hasNext()) {
                String pair = scanner.next();
                String[] parsedpair = pair.split("\\=");
                makrosList.put(parsedpair[0], parsedpair[1]);
            }
            return makrosList;
        }
        IfMapClient.LOGGER.warning("nagios polling-thread detected a unparsable line: " + line);
        return null;
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        while (this.running) {
            block18: {
                block17: {
                    if (this.pausing) continue;
                    this.mConnection = this.mProviderSocket.accept();
                    this.mIn = new DataInputStream(this.mConnection.getInputStream());
                    this.mBufferReader = new BufferedReader(new InputStreamReader(this.mIn));
                    String inputLine = "";
                    inputLine = this.mBufferReader.readLine();
                    if (inputLine == null) break block17;
                    IfMapClient.LOGGER.info("nagios polling-thread received message: " + inputLine + " from " + this.mConnection.getInetAddress().getHostName());
                    this.notify(this.parseLine(inputLine));
                    break block18;
                }
                try {
                    this.mIn.close();
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                    IfMapClient.exit("nagios polling-thread encounters an error while closing streams and socket");
                }
                break;
                {
                    catch (IOException e) {
                        try {
                            try {
                                e.printStackTrace();
                                IfMapClient.exit("nagios polling-thread detected an I/O error while reading from socket");
                            }
                            catch (IOException ioException) {
                                ioException.printStackTrace();
                                IfMapClient.exit("nagios polling-thread encounters an error while building in/output-streams");
                                try {
                                    this.mIn.close();
                                }
                                catch (IOException ioException2) {
                                    ioException2.printStackTrace();
                                    IfMapClient.exit("nagios polling-thread encounters an error while closing streams and socket");
                                }
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                this.mIn.close();
                            }
                            catch (IOException ioException) {
                                ioException.printStackTrace();
                                IfMapClient.exit("nagios polling-thread encounters an error while closing streams and socket");
                            }
                            throw throwable;
                        }
                    }
                }
            }
            try {
                this.mIn.close();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
                IfMapClient.exit("nagios polling-thread encounters an error while closing streams and socket");
            }
        }
    }

    @Override
    public void notify(Object o) {
        if (o != null) {
            ArrayList<HashMap> resultList = new ArrayList<HashMap>();
            resultList.add((HashMap)o);
            if (resultList.size() > 0) {
                this.setChanged();
                this.notifyObservers(resultList);
            } else {
                IfMapClient.LOGGER.info("no updates received from nagios-socket, not calling observer");
            }
        } else {
            IfMapClient.LOGGER.warning("retrieved message from nagios-socket is empty, not calling observer");
        }
    }
}

