/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.mappingfactory;

import de.esukom.decoit.ifmapclient.config.GeneralConfig;
import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.mappingfactory.EventMappingResult;
import de.esukom.decoit.ifmapclient.mappingfactory.SnortEventMappingFactory;
import de.esukom.decoit.ifmapclient.messaging.SOAPMessageSender;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import de.fhhannover.inform.trust.ifmapj.metadata.EventType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;

public class SnortBarnyardFileEventMappingFactory
extends SnortEventMappingFactory {
    private final boolean mSkipIP6 = true;

    public SnortBarnyardFileEventMappingFactory(Properties props, ArrayList<HashMap<String, String>> data) {
        super(props, data);
    }

    @Override
    protected void createMappingResult(Properties props, ArrayList<HashMap<String, String>> res) {
        super.initProperties(props);
        int i = 0;
        while (i < res.size()) {
            EventType msgType = null;
            String discTime = null;
            Matcher classMatcher = Toolbox.getRegExPattern("Classification:[\\w\\s]+").matcher(res.get(i).get("0"));
            if (classMatcher.find()) {
                msgType = this.getEventMappingForSignatureName(classMatcher.group().replace("Classification: ", ""));
            } else {
                msgType = EventType.other;
                IfMapClient.LOGGER.warning("could not find classification for entry[" + i + "]...using default (other)");
            }
            Matcher timestampMatcher = Toolbox.getRegExPattern("\\d{2}\\/\\d{2}\\-\\d{2}\\:\\d{2}\\:\\d{2}\\.\\d{6}").matcher(res.get(i).get("0"));
            if (timestampMatcher.find()) {
                discTime = String.valueOf(Toolbox.getCurrentYear()) + "/" + timestampMatcher.group();
                if (!GeneralConfig.APPLICATION_MESSAGING_SENDOLD && !Toolbox.getCalendarFromString(this.rearrangeDate(discTime)).after(Toolbox.getCalendarFromString(Toolbox.sClientStartTime))) {
                    discTime = null;
                }
            } else {
                IfMapClient.LOGGER.warning("could not find timestamp for entry[" + i + "]...skipping entry!");
            }
            if (msgType != null && discTime != null && this.doConvert(msgType)) {
                EventMappingResult event = new EventMappingResult();
                event.setEventMessageType(msgType);
                event.setDiscoveredTime(this.convertDateToIFMAPDate(discTime));
                Matcher ipMatcher = Toolbox.getRegExPattern("(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9])[.]){3}(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9]))").matcher(res.get(i).get("0"));
                if (ipMatcher.find()) {
                    event.setIp(ipMatcher.group());
                    event.setIpType("IPv4");
                }
                if (event.getIp() != null) {
                    Matcher vulnaribilityMatcher;
                    Matcher typeMatcher = Toolbox.getRegExPattern("\\]\\s\\(?[\\w\\s]+\\)?\\:?[a-zA-Z0-9\\s\\<\\>\\/\\-\\*]*\\[").matcher(res.get(i).get("0"));
                    if (typeMatcher.find()) {
                        event.setName(typeMatcher.group().replace("] ", "").replace(" [", ""));
                    } else {
                        IfMapClient.LOGGER.warning("could not find event name for entry[" + i + "]");
                    }
                    Matcher priorityMatcher = Toolbox.getRegExPattern("Priority:\\s\\d").matcher(res.get(i).get("0"));
                    if (priorityMatcher.find()) {
                        event.setSignificance(this.getSignificanceValue(new Integer(priorityMatcher.group().replace("Priority: ", ""))));
                    } else {
                        IfMapClient.LOGGER.warning("could not find priority for entry[" + i + "]");
                    }
                    if (res.get(i).get("0") != null && (vulnaribilityMatcher = Toolbox.getRegExPattern("\\[Xref.+\\]").matcher(res.get(i).get("0"))).find()) {
                        event.setVulnerabilityUri(vulnaribilityMatcher.group().replace("[Xref => ", "").replace("]h", " ; h").replace("]", ""));
                        event.setVulnerabilityUri("http://cve.mitre.org/cgi-bin/cvename.cgi?name=2005-0068");
                    }
                    event.setDiscovererId(SOAPMessageSender.getInstance().getIfMapPublisherId());
                    event.setConfidence("100");
                    event.setMagnitude("45");
                    this.mapResult.add(event);
                    IfMapClient.LOGGER.fine("mapped snort event has been added to result list: " + event.showOnConsole());
                }
            }
            ++i;
        }
    }

    private String rearrangeDate(String currentDate) {
        String[] timestamp = currentDate.split("-");
        String[] date = timestamp[0].split("/");
        String newDate = String.valueOf(date[0]) + "-" + date[1] + "-" + date[2] + " " + timestamp[1];
        return newDate.substring(0, newDate.length() - 7);
    }

    private String convertDateToIFMAPDate(String currentDate) {
        String[] timestamp = currentDate.split("-");
        String[] date = timestamp[0].split("/");
        String newDate = String.valueOf(date[0]) + "-" + date[1] + "-" + date[2] + "T" + timestamp[1];
        return String.valueOf(newDate.substring(0, newDate.length() - 7)) + "Z";
    }
}

