/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.mappingfactory;

import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.mappingfactory.EventMappingResult;
import de.esukom.decoit.ifmapclient.mappingfactory.RadiusEventMappingFactory;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import de.fhhannover.inform.trust.ifmapj.metadata.EventType;
import de.fhhannover.inform.trust.ifmapj.metadata.Significance;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;

public class RadiusSQLEventMappingFactory
extends RadiusEventMappingFactory {
    private final String mDbColumnEventId = "radacctid";
    private final String mDbColumnSessionId = "acctsessionid";
    private final String mDbColumnUsername = "username";
    private final String mDbColumnIfAddress = "nasipaddress";
    private final String mDbColumnAcctStarttime = "acctstarttime";
    private final String mDbColumnAcctStoptime = "acctstoptime";
    private final String mDbColumnSessionTimeDB_COLUMN_SESSION_TIME = "acctsessiontime";
    private boolean firstStart = true;
    private final String mDbColumnId = "id";
    private final String mDbColumnReply = "reply";
    private final String mDbColumnAuthenticationDate = "authdate";
    private EventType mEventtypeDefault;
    private String mMagnitudeDefault;
    private String mConfidenceDefault;
    private Significance mSignificanceDefault;

    public RadiusSQLEventMappingFactory(Properties props, ArrayList<HashMap<String, String>> data) {
        super(props, data);
    }

    @Override
    protected void createMappingResult(Properties props, ArrayList<HashMap<String, String>> data) {
        this.initProperties(props);
        int i = 0;
        while (i < data.size()) {
            if (data.get(i).containsKey("acctstarttime")) {
                System.out.print(String.valueOf(data.get(i).get("radacctid")) + " ");
                System.out.print(String.valueOf(data.get(i).get("username")) + " ");
                System.out.print(String.valueOf(data.get(i).get("acctsessionid")) + " ");
                System.out.print(String.valueOf(data.get(i).get("nasipaddress")) + " ");
                System.out.print(String.valueOf(data.get(i).get("acctstarttime").replace(".0", "")) + " ");
                if (data.get(i).get("acctstoptime") != null) {
                    System.out.print(String.valueOf(data.get(i).get("acctstoptime").replace(".0", "")) + " ");
                }
                System.out.println(data.get(i).get("acctsessiontime"));
            } else {
                System.out.print(String.valueOf(data.get(i).get("id")) + " ");
                System.out.print(String.valueOf(data.get(i).get("username")) + " ");
                System.out.print(String.valueOf(data.get(i).get("reply")) + " ");
                System.out.println(data.get(i).get("authdate").replace(".0", ""));
            }
            ++i;
        }
        if (!this.firstStart) {
            i = 0;
            while (i < data.size()) {
                SimpleDateFormat ifmapTimeStyle = new SimpleDateFormat("yyyy-MM-dd'T'kk:mm:ss'Z'");
                SimpleDateFormat parseStringDate = new SimpleDateFormat("yyyy-MM-DD kk:mm:ss");
                EventMappingResult event = new EventMappingResult();
                if (data.get(i).containsKey("acctstoptime")) {
                    if (data.get(i).get("acctstoptime") == null) {
                        event.setName("Accounting Start");
                        Date startTime = null;
                        try {
                            startTime = parseStringDate.parse(data.get(i).get("acctstarttime").replace(".0", ""));
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        event.setDiscoveredTime(ifmapTimeStyle.format(startTime).toString());
                    } else {
                        Date stopTime = null;
                        try {
                            if (data.get(i).get("acctstoptime") != null) {
                                stopTime = parseStringDate.parse(data.get(i).get("acctstoptime").replace(".0", ""));
                            }
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        event.setName("Accounting Stop");
                        event.setDiscoveredTime(ifmapTimeStyle.format(stopTime).toString());
                    }
                    event.setIdentity(data.get(i).get("username"));
                    if (event.getIdentity().equalsIgnoreCase("")) {
                        event.setIdentity("Unknown");
                    }
                    event.setIp(data.get(i).get("nasipaddress"));
                    event.setIpType("IPv4");
                    event.setConfidence(this.mConfidenceDefault);
                    event.setMagnitude(this.mMagnitudeDefault);
                    event.setSignificance(this.mSignificanceDefault);
                    event.setEventMessageType(this.mEventtypeDefault);
                } else {
                    event.setName("Authentication: " + data.get(i).get("reply"));
                    event.setIdentity(data.get(i).get("username"));
                    Date authenticationTime = null;
                    try {
                        authenticationTime = parseStringDate.parse(data.get(i).get("authdate").replace(".0", ""));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    event.setDiscoveredTime(ifmapTimeStyle.format(authenticationTime).toString());
                    if (data.get(i).get("reply").equalsIgnoreCase("Access-Accept")) {
                        event.setSignificance(Significance.critical);
                    } else {
                        event.setSignificance(Significance.informational);
                    }
                    event.setIp("0.0.0.0");
                    event.setConfidence(this.mConfidenceDefault);
                    event.setMagnitude(this.mMagnitudeDefault);
                    event.setSignificance(this.mSignificanceDefault);
                    event.setEventMessageType(this.mEventtypeDefault);
                }
                this.mapResult.add(event);
                ++i;
            }
        } else {
            this.firstStart = false;
        }
        System.out.println("test");
    }

    @Override
    public void initProperties(Properties props) {
        boolean criticalErrorOcured = false;
        this.mEventtypeDefault = EventType.behavioralChange;
        String eventTypeFromConfig = Toolbox.getStringProperty("radius.eventmapping.eventtype", props, false);
        if (this.mEventtypeDefault == null) {
            criticalErrorOcured = true;
        }
        if (eventTypeFromConfig == "botnet-infection") {
            this.mEventtypeDefault = EventType.botnetInfection;
        } else if (eventTypeFromConfig == "cve") {
            this.mEventtypeDefault = EventType.cve;
        } else if (eventTypeFromConfig == "excessive-flows") {
            this.mEventtypeDefault = EventType.excessiveFlows;
        } else if (eventTypeFromConfig == "other") {
            this.mEventtypeDefault = EventType.other;
        } else if (eventTypeFromConfig == "p2p") {
            this.mEventtypeDefault = EventType.p2p;
        } else if (eventTypeFromConfig == "policy-violation") {
            this.mEventtypeDefault = EventType.policyViolation;
        } else if (eventTypeFromConfig == "worm-infection") {
            this.mEventtypeDefault = EventType.wormInfection;
        } else {
            IfMapClient.LOGGER.config("could not load default event-type value from radius mapping config...using default (behavioral-change)");
        }
        this.mMagnitudeDefault = Toolbox.getStringProperty("radius.eventmapping.magnitude", props, false);
        if (this.mMagnitudeDefault == null) {
            criticalErrorOcured = true;
        }
        this.mConfidenceDefault = Toolbox.getStringProperty("radius.eventmapping.confidence", props, false);
        if (this.mConfidenceDefault == null) {
            criticalErrorOcured = true;
        }
        this.mSignificanceDefault = Significance.informational;
        String significanceFromConfig = Toolbox.getStringProperty("radius.eventmapping.significance", props, false);
        if (significanceFromConfig == "important") {
            this.mSignificanceDefault = Significance.important;
        } else if (significanceFromConfig == "critical") {
            this.mSignificanceDefault = Significance.critical;
        } else {
            IfMapClient.LOGGER.config("could not load default significance value from nagios mapping config...using default (informational)");
        }
        if (criticalErrorOcured) {
            IfMapClient.exit("error while initializing NagiosEventMappingFactory");
        }
    }
}

