/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.pollingthreads;

import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.pollingthreads.PollingThread;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public abstract class SqlPollingThread
extends PollingThread {
    public String databaseName;
    public String databaseHost;
    public String databaseUser;
    public String databasePass;
    public Connection connect = null;
    public PreparedStatement prepStatement = null;
    public String rawQuery;
    public int lastCid = 0;
    public String identFieldName;

    @Override
    protected void initProperties(Properties props) {
        this.databaseHost = props.getProperty("database.host", null);
        this.databaseName = props.getProperty("database.name", null);
        this.databaseUser = props.getProperty("database.user", null);
        this.databasePass = props.getProperty("database.pass", null);
        if (this.databaseHost == null || this.databaseHost.length() == 0) {
            IfMapClient.exit("error while initializing SqlPolling Thread - property DATABASE-HOST cannot be null or empty!");
        } else if (this.databaseName == null || this.databaseName.length() == 0) {
            IfMapClient.exit("error while initializing SqlPolling Thread: - property DATABASE-NAME cannot be null or empty!");
        } else if (this.databaseUser == null || this.databaseUser.length() == 0) {
            IfMapClient.exit("error while initializing SqlPolling Thread - property DATABASE-USER cannot be null or empty!");
        } else if (this.databasePass == null || this.databasePass.length() == 0) {
            IfMapClient.exit("error while initializing SqlPolling Thread - property DATABASE-PASS cannot be null or empty!");
        }
    }

    protected void initDatabaseConnection(String host, String name, String user, String pass) {
        IfMapClient.LOGGER.config("initalizing database connection with host " + host + " and name " + name + " as user " + user + "...");
        try {
            Class.forName("com.mysql.jdbc.Driver");
            this.connect = DriverManager.getConnection("jdbc:mysql://" + host + "/" + name, user, pass);
        }
        catch (Exception e) {
            e.printStackTrace();
            IfMapClient.exit("sql-polling-thread encountered an error while connecting to database " + name + " at host " + host + " with user " + user + "...please check your configuration");
        }
    }

    @Override
    public void notify(Object o) {
        if (o != null) {
            ResultSet result = (ResultSet)o;
            ArrayList<HashMap<String, String>> resultList = this.getResultList(result);
            if (resultList != null && resultList.size() > 0) {
                this.pausing = true;
                this.lastCid = new Integer(resultList.get(resultList.size() - 1).get(this.identFieldName));
                this.setChanged();
                this.notifyObservers(resultList);
            } else {
                IfMapClient.LOGGER.info("no new entries in " + this.databaseName + "-database, not calling observer");
            }
        } else {
            IfMapClient.LOGGER.warning("retrieved snort-database result is null, not calling observer");
        }
    }

    @Override
    public void run() {
        while (this.running) {
            if (this.pausing) continue;
            try {
                IfMapClient.LOGGER.info("checking " + this.databaseName + " database for updates...");
                this.connect.setAutoCommit(false);
                System.out.println(this.rawQuery);
                this.prepStatement.setInt(1, this.lastCid);
                ResultSet resultSet = this.prepStatement.executeQuery();
                this.connect.commit();
                this.notify(resultSet);
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    IfMapClient.exit("sql-polling-thread encountered an error while thread is trying to get some sleep...please be quit ;-)");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                IfMapClient.exit("sql-polling-thread encountered an error while executing the db query");
            }
        }
    }

    protected abstract ArrayList<HashMap<String, String>> getResultList(ResultSet var1);
}

