/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.pollingthreads;

import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.pollingthreads.PollingThread;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public abstract class FilePollingThread
extends PollingThread {
    public String filePath;
    public File file;
    public boolean isFirstStart = false;
    public int lastEntryLineNumber = 0;
    public long lastModified;

    @Override
    protected void initProperties(Properties props) {
        this.filePath = props.getProperty("filepath", null);
        if (this.filePath == null || this.filePath.length() == 0) {
            IfMapClient.exit("error while initializing SnortBarnyardFilePolling Thread - file path cannot be null or empty, please check your configuration");
        }
        this.isFirstStart = true;
        IfMapClient.LOGGER.config("opening log-file at path: " + this.filePath + "...");
        if (new File(this.filePath).exists()) {
            this.file = new File(this.filePath);
        } else {
            IfMapClient.exit("log-file at " + this.filePath + " doesnt exist...please check your configuration");
        }
        this.lastModified = this.file.lastModified();
    }

    @Override
    public void run() {
        while (this.running) {
            if (this.pausing) continue;
            try {
                long actualLastModified = this.file.lastModified();
                IfMapClient.LOGGER.info("checking log-file  " + this.filePath + " for updates...");
                if (this.isFirstStart | this.lastModified != actualLastModified) {
                    this.lastModified = actualLastModified;
                    IfMapClient.LOGGER.info("log-file " + this.filePath + " has been updated, looking for new entries...");
                    this.notify(this.readFile());
                } else {
                    IfMapClient.LOGGER.info("log-file " + this.filePath + " has not been updated...");
                }
                Thread.sleep(this.sleepTime);
            }
            catch (Exception e) {
                e.printStackTrace();
                IfMapClient.exit("error while checking log-file  " + this.filePath + " for updates");
            }
        }
    }

    @Override
    public void notify(Object o) {
        if (o != null) {
            ArrayList resultList = (ArrayList)o;
            if (resultList.size() > 0) {
                this.pausing = true;
                this.setChanged();
                this.notifyObservers(resultList);
            } else {
                IfMapClient.LOGGER.info("no new entries in  " + this.filePath + "  log-file, not calling observer");
            }
        } else {
            IfMapClient.LOGGER.info("retrieved update in  " + this.filePath + " log-file is null, not calling observer");
        }
    }

    protected abstract ArrayList<HashMap<String, String>> readFile();
}

