/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.mappingfactory;

import de.esukom.decoit.ifmapclient.config.GeneralConfig;
import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.mappingfactory.EventMappingResult;
import de.esukom.decoit.ifmapclient.mappingfactory.SnortEventMappingFactory;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class SnortSqlEventMappingFactory
extends SnortEventMappingFactory {
    private final String mColumnSignature = "sig_name";
    private final String mColumnEventId = "cid";
    private final String mColumnReftag = "ref_tag";
    private final String mColumnIp = "inet_ntoa(iphdr.ip_src)";
    private final String mColumnTimestamp = "timestamp";
    private final String mColumnSensorId = "sid";
    private final String mColumnIpVersion = "ip_ver";
    private final String mColumnPriority = "sig_priority";
    private final String mColumnSignatureClassName = "sig_class_name";
    private final String mColumnRefSystemName = "ref_system_name";

    public SnortSqlEventMappingFactory(Properties props, ArrayList<HashMap<String, String>> data) {
        super(props, data);
    }

    @Override
    protected void createMappingResult(Properties props, ArrayList<HashMap<String, String>> res) {
        super.initProperties(props);
        int lastEventCID = -1;
        EventMappingResult lastEntry = null;
        int i = 0;
        while (i < res.size()) {
            boolean isFollowUp = false;
            if (lastEventCID != -1 && new Integer(res.get(i).get("cid")) == lastEventCID) {
                isFollowUp = true;
            }
            if (!isFollowUp || lastEntry == null) {
                if (this.doConvert(this.getEventMappingForSignatureName(res.get(i).get("sig_class_name")))) {
                    if (lastEntry != null) {
                        if (GeneralConfig.APPLICATION_MESSAGING_SENDOLD) {
                            this.mapResult.add(lastEntry);
                            IfMapClient.LOGGER.fine("mapped snort event has been added to result list: " + lastEntry.showOnConsole());
                        } else if (Toolbox.getCalendarFromString(lastEntry.getDiscoveredTime()).after(Toolbox.getCalendarFromString(Toolbox.sClientStartTime))) {
                            this.mapResult.add(lastEntry);
                        }
                    }
                    EventMappingResult event = new EventMappingResult();
                    event.setConfidence("100");
                    event.setMagnitude("45");
                    event.setIpType("IPv" + res.get(i).get("ip_ver").toString());
                    event.setIp(res.get(i).get("inet_ntoa(iphdr.ip_src)"));
                    event.setDiscoveredTime(this.convertDateToIFMAPDate(res.get(i).get("timestamp")));
                    event.setDiscovererId(res.get(i).get("sid"));
                    event.setSignificance(this.getSignificanceValue(new Integer(res.get(i).get("sig_priority"))));
                    event.setName(res.get(i).get("sig_name"));
                    event.setEventMessageType(this.getEventMappingForSignatureName(res.get(i).get("sig_class_name")));
                    if (res.get(i).get("ref_system_name") != null && res.get(i).get("ref_tag") != null) {
                        if (res.get(i).get("ref_system_name").equals("cve")) {
                            event.setVulnerabilityUri("cve (common vulnerabilities and exposures)");
                        } else if (res.get(i).get("ref_system_name").equals("url")) {
                            event.setVulnerabilityUri("cve (common vulnerabilities and exposures)");
                        } else if (res.get(i).get("ref_system_name").equals("arachNIDS")) {
                            event.setVulnerabilityUri("arachnids");
                        } else if (res.get(i).get("ref_system_name").equals("bugtrack")) {
                            event.setVulnerabilityUri("bugtrack");
                        } else if (res.get(i).get("ref_system_name").equals("nessus")) {
                            event.setVulnerabilityUri("nessus");
                        }
                    }
                    lastEntry = (EventMappingResult)event.clone();
                }
                lastEventCID = new Integer(res.get(i).get("cid"));
            }
            ++i;
        }
        if (lastEntry != null) {
            if (GeneralConfig.APPLICATION_MESSAGING_SENDOLD) {
                this.mapResult.add(lastEntry);
            } else if (Toolbox.getCalendarFromString(lastEntry.getDiscoveredTime()).after(Toolbox.getCalendarFromString(Toolbox.sClientStartTime))) {
                this.mapResult.add(lastEntry);
                IfMapClient.LOGGER.fine("mapped snort event has been added to result list: " + lastEntry.showOnConsole());
            }
        }
    }

    public String getColumnReftag() {
        return "ref_tag";
    }

    private String convertDateToIFMAPDate(String currentDate) {
        String[] timestamp = currentDate.split(" ");
        String[] date = timestamp[0].split("-");
        String newDate = String.valueOf(date[0]) + "-" + date[1] + "-" + date[2] + "T" + timestamp[1];
        return String.valueOf(newDate.substring(0, newDate.length() - 2)) + "Z";
    }
}

