/*
 * Decompiled with CFR 0.152.
 */
package de.fhhannover.inform.trust.ifmapj.channel;

import de.fhhannover.inform.trust.ifmapj.channel.ARC;
import de.fhhannover.inform.trust.ifmapj.channel.AbstractChannel;
import de.fhhannover.inform.trust.ifmapj.channel.ArcImpl;
import de.fhhannover.inform.trust.ifmapj.channel.SSRC;
import de.fhhannover.inform.trust.ifmapj.exception.CommunicationException;
import de.fhhannover.inform.trust.ifmapj.exception.IfmapErrorResult;
import de.fhhannover.inform.trust.ifmapj.exception.IfmapException;
import de.fhhannover.inform.trust.ifmapj.exception.InitializationException;
import de.fhhannover.inform.trust.ifmapj.messages.EndSessionRequest;
import de.fhhannover.inform.trust.ifmapj.messages.NewSessionRequest;
import de.fhhannover.inform.trust.ifmapj.messages.NewSessionResult;
import de.fhhannover.inform.trust.ifmapj.messages.PublishRequest;
import de.fhhannover.inform.trust.ifmapj.messages.PurgePublisherRequest;
import de.fhhannover.inform.trust.ifmapj.messages.RenewSessionRequest;
import de.fhhannover.inform.trust.ifmapj.messages.Requests;
import de.fhhannover.inform.trust.ifmapj.messages.Result;
import de.fhhannover.inform.trust.ifmapj.messages.SearchRequest;
import de.fhhannover.inform.trust.ifmapj.messages.SearchResult;
import de.fhhannover.inform.trust.ifmapj.messages.SubscribeRequest;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;

public class SsrcImpl
extends AbstractChannel
implements SSRC {
    private String mSessionId;
    private String mPublisherId;
    private Integer mMaxPollResultSize;
    private KeyManager[] mKeyManagers;
    private TrustManager[] mTrustManagers;

    public SsrcImpl(String url, String user, String pass, TrustManager[] tms) throws InitializationException {
        super(url, user, pass, tms);
        this.mTrustManagers = tms;
    }

    public SsrcImpl(String url, KeyManager[] kms, TrustManager[] tms) throws InitializationException {
        super(url, kms, tms);
        this.mKeyManagers = kms;
        this.mTrustManagers = tms;
    }

    @Override
    public void newSession(Integer maxPollResSize) throws IfmapErrorResult, IfmapException {
        NewSessionRequest nsreq = Requests.createNewSessionReq();
        nsreq.setMaxPollResultSize(maxPollResSize);
        Result res = this.genericRequest(nsreq);
        if (!(res instanceof NewSessionResult)) {
            throw new RuntimeException("wrong result-type");
        }
        NewSessionResult nsres = (NewSessionResult)res;
        this.mSessionId = null;
        this.mMaxPollResultSize = null;
        this.mPublisherId = null;
        this.mSessionId = nsres.getSessionId();
        this.mPublisherId = nsres.getPublisherId();
        if (maxPollResSize != null) {
            this.mMaxPollResultSize = nsres.getMaxPollResultSize();
            if (this.mMaxPollResultSize == null) {
                throw new CommunicationException("no max-poll-result-size in newSession result");
            }
        }
    }

    @Override
    public void newSession() throws IfmapErrorResult, IfmapException {
        this.newSession(null);
    }

    @Override
    public void endSession() throws IfmapErrorResult, IfmapException {
        EndSessionRequest esr = Requests.createEndSessionReq();
        this.genericRequestWithSessionId(esr);
        this.mPublisherId = null;
        this.mSessionId = null;
        this.mMaxPollResultSize = null;
    }

    @Override
    public void renewSession() throws IfmapErrorResult, IfmapException {
        RenewSessionRequest rsr = Requests.createRenewSessionReq();
        this.genericRequestWithSessionId(rsr);
    }

    @Override
    public void purgePublisher() throws IfmapErrorResult, IfmapException {
        this.purgePublisher(this.getPublisherId());
    }

    @Override
    public void purgePublisher(String publisherId) throws IfmapErrorResult, IfmapException {
        PurgePublisherRequest ppr = Requests.createPurgePublisherReq();
        ppr.setPublisherId(publisherId);
        this.genericRequestWithSessionId(ppr);
    }

    @Override
    public void publish(PublishRequest pr) throws IfmapErrorResult, IfmapException {
        if (pr == null) {
            throw new NullPointerException();
        }
        this.genericRequestWithSessionId(pr);
    }

    @Override
    public void subscribe(SubscribeRequest sr) throws IfmapErrorResult, IfmapException {
        if (sr == null) {
            throw new NullPointerException();
        }
        this.genericRequestWithSessionId(sr);
    }

    @Override
    public SearchResult search(SearchRequest sr) throws IfmapErrorResult, IfmapException {
        if (sr == null) {
            throw new NullPointerException();
        }
        Result res = this.genericRequestWithSessionId(sr);
        if (!(res instanceof SearchResult)) {
            throw new RuntimeException("search returns no SearchResult?");
        }
        return (SearchResult)res;
    }

    @Override
    public ARC getArc() throws InitializationException {
        ArcImpl ret = null;
        ret = this.isBasicAuth() ? new ArcImpl(this, this.getUrl(), this.getUser(), this.getPassword(), this.mTrustManagers) : new ArcImpl(this, this.getUrl(), this.mKeyManagers, this.mTrustManagers);
        if (this.usesGzip()) {
            ret.setGzip(true);
        }
        return ret;
    }

    @Override
    public String getSessionId() {
        return this.mSessionId;
    }

    @Override
    public String getPublisherId() {
        return this.mPublisherId;
    }

    @Override
    public Integer getMaxPollResSize() {
        return this.mMaxPollResultSize;
    }

    @Override
    public void setSessionId(String sessionId) {
        this.mSessionId = sessionId;
    }

    @Override
    public void setPublisherId(String publisherId) {
        this.mPublisherId = publisherId;
    }

    @Override
    public void setMaxPollResSize(Integer mprs) {
        this.mMaxPollResultSize = mprs;
    }
}

