/*
 * Decompiled with CFR 0.152.
 */
package de.fhhannover.inform.trust.ifmapj.channel;

import de.fhhannover.inform.trust.ifmapj.channel.AbstractCommunicationHandler;
import de.fhhannover.inform.trust.ifmapj.exception.InitializationException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.DefaultHttpClientConnection;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

class ApacheCoreCommunicationHandler
extends AbstractCommunicationHandler {
    private final BasicHttpParams mBasicHttpParams = new BasicHttpParams();
    private DefaultHttpClientConnection mHttpConnection;
    private boolean mResponseGzip;
    private BasicHttpEntityEnclosingRequest mHttpPost;

    ApacheCoreCommunicationHandler(String url, String user, String pass, SSLSocketFactory sslSocketFactory, HostnameVerifier verifier) throws InitializationException {
        super(url, user, pass, sslSocketFactory, verifier);
    }

    @Override
    public InputStream doActualRequest(InputStream is) throws IOException {
        InputStreamEntity ise = null;
        HttpResponse response = null;
        InputStream ret = null;
        Header hdr = null;
        HttpEntity respEntity = null;
        StatusLine status = null;
        ise = new InputStreamEntity(is, (long)is.available());
        ise.setChunked(false);
        this.mHttpPost.setEntity((HttpEntity)ise);
        try {
            this.mHttpConnection.sendRequestHeader((HttpRequest)this.mHttpPost);
            this.mHttpConnection.sendRequestEntity((HttpEntityEnclosingRequest)this.mHttpPost);
            response = this.mHttpConnection.receiveResponseHeader();
            this.mHttpConnection.receiveResponseEntity(response);
        }
        catch (HttpException e) {
            throw new IOException(e);
        }
        status = response.getStatusLine();
        if (status.getStatusCode() != 200) {
            throw new IOException("HTTP Status Code: " + status.getStatusCode() + " " + status.getReasonPhrase());
        }
        hdr = response.getFirstHeader("Content-Encoding");
        this.mResponseGzip = hdr == null ? false : hdr.getValue().contains("gzip");
        respEntity = response.getEntity();
        if (respEntity != null) {
            ret = respEntity.getContent();
        }
        if (ret == null) {
            throw new IOException("no content in response");
        }
        return ret;
    }

    @Override
    protected void prepareCommunication() throws IOException {
        if (this.mHttpConnection == null) {
            this.mHttpConnection = new DefaultHttpClientConnection();
            this.mHttpConnection.bind((Socket)this.getSocket(), (HttpParams)this.mBasicHttpParams);
        }
    }

    @Override
    protected void createPostRequest(String path) throws IOException {
        this.mHttpPost = new BasicHttpEntityEnclosingRequest("POST", path);
    }

    @Override
    protected void addHeader(String key, String value) throws IOException {
        this.mHttpPost.addHeader(key, value);
    }

    @Override
    protected void finishHeaders() throws IOException {
    }

    @Override
    protected boolean replyIsGzipped() throws IOException {
        return this.mResponseGzip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeTcpConnectionImpl() throws IOException {
        IOException tmp = null;
        try {
            if (this.mHttpConnection != null) {
                this.mHttpConnection.close();
            }
        }
        catch (IOException e) {
            tmp = e;
        }
        finally {
            this.mHttpConnection = null;
        }
        if (tmp != null) {
            throw tmp;
        }
    }
}

