/*
 * Decompiled with CFR 0.152.
 */
package de.fhhannover.inform.trust.ifmapj.channel;

import de.fhhannover.inform.trust.ifmapj.channel.CommunicationHandler;
import de.fhhannover.inform.trust.ifmapj.exception.CommunicationException;
import de.fhhannover.inform.trust.ifmapj.exception.InitializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import util.Base64;

abstract class AbstractCommunicationHandler
implements CommunicationHandler {
    private final SSLSocketFactory mSocketFactory;
    private SSLSocket mSocket;
    private final String mAuthHeaderValue;
    private final boolean mBasicAuth;
    private final String mPath;
    private final URL mUrl;
    private final int mPort;
    private boolean mGzip;
    private HostnameVerifier mHostnameVerifier;

    AbstractCommunicationHandler(String url, String user, String pass, SSLSocketFactory sslSocketFactory, HostnameVerifier verifier) throws InitializationException {
        if (url == null) {
            throw new NullPointerException("url is null");
        }
        if (sslSocketFactory == null) {
            throw new NullPointerException("sslSocketFactory is null");
        }
        if (verifier == null) {
            throw new NullPointerException("verifier is null");
        }
        try {
            this.mUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new InitializationException("Malformed URL [" + e.getMessage() + "]");
        }
        this.mPath = this.mUrl.getPath().length() == 0 ? "/" : this.mUrl.getPath();
        this.mPort = this.mUrl.getPort() == -1 ? this.mUrl.getDefaultPort() : this.mUrl.getPort();
        this.mBasicAuth = user != null && pass != null;
        this.mAuthHeaderValue = this.mBasicAuth ? "Basic " + Base64.encodeToString((user + ":" + pass).getBytes(), false) : null;
        this.mSocketFactory = sslSocketFactory;
        this.mHostnameVerifier = verifier;
    }

    @Override
    public final InputStream doRequest(InputStream httpBody) throws CommunicationException {
        InputStream reply = null;
        try {
            this.getSocket();
            this.prepareCommunication();
            this.createPostRequest(this.getPath());
            this.writeHostLine();
            this.writeContentTypeHeaders();
            if (this.usesGzip()) {
                httpBody = this.compressInputStream(httpBody);
                this.writeGzipHeaders();
            }
            if (this.usesBasicAuth()) {
                this.writeAuthHeader();
            }
            this.writeContentLengthHeader(httpBody.available());
            this.finishHeaders();
            reply = this.doActualRequest(httpBody);
            if (this.replyIsGzipped()) {
                reply = new GZIPInputStream(reply);
            }
            return reply;
        }
        catch (IOException e) {
            throw new CommunicationException(e.getMessage());
        }
    }

    private void writeHostLine() throws IOException {
        this.addHeader("Host", this.getUrl().getHost() + ":" + this.getPort());
    }

    private void writeContentTypeHeaders() throws IOException {
        this.addHeader("Accept-Type", "application/soap+xml");
        this.addHeader("Content-Type", "application/soap+xml");
    }

    private void writeGzipHeaders() throws IOException {
        this.addHeader("Accept-Encoding", "gzip");
        this.addHeader("Content-Encoding", "gzip");
    }

    private void writeAuthHeader() throws IOException {
        this.addHeader("Authorization", this.getAuthHeaderValue());
    }

    private void writeContentLengthHeader(int length) throws IOException {
        this.addHeader("Content-Length", "" + length);
    }

    @Override
    public void setGzip(boolean gzip) {
        this.mGzip = gzip;
    }

    @Override
    public boolean usesGzip() {
        return this.mGzip;
    }

    protected SSLSocket getSocket() throws IOException {
        if (this.mSocket == null) {
            try {
                this.closeTcpConnection();
            }
            catch (CommunicationException e) {
                throw new IOException(e.getMessage());
            }
            this.mSocket = this.getNewSocket();
        }
        return this.mSocket;
    }

    private SSLSocket getNewSocket() throws IOException {
        SSLSocket ret = (SSLSocket)this.mSocketFactory.createSocket(this.getUrl().getHost(), this.getPort());
        ret.setTcpNoDelay(true);
        ret.setWantClientAuth(true);
        ret.getSession().getPeerCertificates();
        if (!this.mHostnameVerifier.verify(this.mUrl.getHost(), ret.getSession())) {
            throw new IOException("Hostname Verification failed! Did you set ifmapj.communication.verifypeerhost?");
        }
        return ret;
    }

    private String getAuthHeaderValue() {
        return this.mAuthHeaderValue;
    }

    private boolean usesBasicAuth() {
        return this.mBasicAuth;
    }

    private String getPath() {
        return this.mPath;
    }

    protected URL getUrl() {
        return this.mUrl;
    }

    protected int getPort() {
        return this.mPort;
    }

    protected abstract void prepareCommunication() throws IOException;

    protected abstract void createPostRequest(String var1) throws IOException;

    protected abstract void addHeader(String var1, String var2) throws IOException;

    protected abstract void finishHeaders() throws IOException;

    protected abstract InputStream doActualRequest(InputStream var1) throws IOException, CommunicationException;

    protected abstract boolean replyIsGzipped() throws IOException;

    protected abstract void closeTcpConnectionImpl() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void closeTcpConnection() throws CommunicationException {
        IOException tmpException = null;
        try {
            this.closeTcpConnectionImpl();
        }
        catch (IOException e) {
            tmpException = e;
        }
        finally {
            try {
                if (this.mSocket != null) {
                    this.mSocket.close();
                }
            }
            catch (IOException e) {
                tmpException = e;
            }
            finally {
                this.mSocket = null;
            }
        }
        if (tmpException != null) {
            throw new CommunicationException(tmpException);
        }
    }

    private InputStream compressInputStream(InputStream is) throws IOException {
        int next = -1;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream os = new GZIPOutputStream(baos);
        while ((next = is.read()) >= 0) {
            ((OutputStream)os).write(next);
        }
        baos.close();
        ((OutputStream)os).close();
        is.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

